/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.callback;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.callbacks.DeleteCallbackFacetFactory;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovedCallbackFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovingCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.RemovingCallbackFacetViaMethod;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class DeleteCallbackFacetFactoryTest
extends AbstractFacetFactoryTest {
    private DeleteCallbackFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new DeleteCallbackFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        DeleteCallbackFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        DeleteCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        DeleteCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        DeleteCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        DeleteCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testDeletingLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void deleting() {
            }
        }
        Method method = this.findMethod(Customer.class, "deleting");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(RemovingCallbackFacet.class);
        DeleteCallbackFacetFactoryTest.assertNotNull((Object)facet);
        DeleteCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof RemovingCallbackFacetViaMethod));
        RemovingCallbackFacetViaMethod deletingCallbackFacetViaMethod = (RemovingCallbackFacetViaMethod)facet;
        DeleteCallbackFacetFactoryTest.assertEquals((Object)method, deletingCallbackFacetViaMethod.getMethods().get(0));
        DeleteCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }

    public void testDeletedLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void deleted() {
            }
        }
        Method method = this.findMethod(Customer.class, "deleted");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(RemovedCallbackFacet.class);
        DeleteCallbackFacetFactoryTest.assertNotNull((Object)facet);
        DeleteCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof RemovedCallbackFacetViaMethod));
        RemovedCallbackFacetViaMethod deletedCallbackFacetViaMethod = (RemovedCallbackFacetViaMethod)facet;
        DeleteCallbackFacetFactoryTest.assertEquals((Object)method, deletedCallbackFacetViaMethod.getMethods().get(0));
        DeleteCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }
}

