/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.callback;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistCallbackFacetFactory;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistedCallbackFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistingCallbackFacetViaMethod;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class PersistCallbackFacetFactoryTest
extends AbstractFacetFactoryTest {
    private PersistCallbackFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new PersistCallbackFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        PersistCallbackFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        PersistCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        PersistCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        PersistCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        PersistCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testPersistingLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void persisting() {
            }
        }
        Method method = this.findMethod(Customer.class, "persisting");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PersistingCallbackFacet.class);
        PersistCallbackFacetFactoryTest.assertNotNull((Object)facet);
        PersistCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof PersistingCallbackFacetViaMethod));
        PersistingCallbackFacetViaMethod persistingCallbackFacetViaMethod = (PersistingCallbackFacetViaMethod)facet;
        PersistCallbackFacetFactoryTest.assertEquals((Object)method, persistingCallbackFacetViaMethod.getMethods().get(0));
        PersistCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }

    public void testPersistedLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void persisted() {
            }
        }
        Method method = this.findMethod(Customer.class, "persisted");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PersistedCallbackFacet.class);
        PersistCallbackFacetFactoryTest.assertNotNull((Object)facet);
        PersistCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof PersistedCallbackFacetViaMethod));
        PersistedCallbackFacetViaMethod persistedCallbackFacetViaMethod = (PersistedCallbackFacetViaMethod)facet;
        PersistCallbackFacetFactoryTest.assertEquals((Object)method, persistedCallbackFacetViaMethod.getMethods().get(0));
        PersistCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }
}

