/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.encodeable;

import org.nakedobjects.applib.adapters.EncoderDecoder;
import org.nakedobjects.applib.annotation.Encodeable;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.prop.PropertiesConfiguration;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacetAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class EncodeableFacetFactoryTest
extends AbstractFacetFactoryTest {
    private EncodeableAnnotationFacetFactory facetFactory;
    private PropertiesConfiguration propertiesConfiguration;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new EncodeableAnnotationFacetFactory();
        this.propertiesConfiguration = new PropertiesConfiguration();
        this.facetFactory.setNakedObjectConfiguration((NakedObjectConfiguration)this.propertiesConfiguration);
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        EncodeableFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        EncodeableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        EncodeableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        EncodeableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        EncodeableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testFacetPickedUp() {
        this.facetFactory.process(MyEncodeableUsingEncoderDecoderName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodeableFacet facet = (EncodeableFacet)this.facetHolder.getFacet(EncodeableFacet.class);
        EncodeableFacetFactoryTest.assertNotNull((Object)facet);
        EncodeableFacetFactoryTest.assertTrue((boolean)(facet instanceof EncodeableFacetAbstract));
    }

    public void testFacetFacetHolderStored() {
        this.facetFactory.process(MyEncodeableUsingEncoderDecoderName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodeableFacetAbstract valueFacet = (EncodeableFacetAbstract)this.facetHolder.getFacet(EncodeableFacet.class);
        EncodeableFacetFactoryTest.assertEquals((Object)this.facetHolder, (Object)valueFacet.getFacetHolder());
    }

    public void testNoMethodsRemoved() {
        this.facetFactory.process(MyEncodeableUsingEncoderDecoderName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        this.assertNoMethodsRemoved();
    }

    public void testEncodeableUsingEncoderDecoderName() {
        this.facetFactory.process(MyEncodeableUsingEncoderDecoderName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodeableFacetAbstract encodeableFacet = (EncodeableFacetAbstract)this.facetHolder.getFacet(EncodeableFacet.class);
        EncodeableFacetFactoryTest.assertEquals(MyEncodeableUsingEncoderDecoderName.class, (Object)encodeableFacet.getEncoderDecoderClass());
    }

    public void testEncodeableUsingEncoderDecoderClass() {
        this.facetFactory.process(MyEncodeableUsingEncoderDecoderClass.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodeableFacetAbstract encodeableFacet = (EncodeableFacetAbstract)this.facetHolder.getFacet(EncodeableFacet.class);
        EncodeableFacetFactoryTest.assertEquals(MyEncodeableUsingEncoderDecoderClass.class, (Object)encodeableFacet.getEncoderDecoderClass());
    }

    public void testEncodeableMustBeAEncoderDecoder() {
    }

    public void testEncodeableHaveANoArgConstructor() {
        this.facetFactory.process(MyEncodeableWithoutNoArgConstructor.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodeableFacetAbstract encodeableFacet = (EncodeableFacetAbstract)this.facetHolder.getFacet(EncodeableFacet.class);
        EncodeableFacetFactoryTest.assertNull((Object)encodeableFacet);
    }

    public void testEncodeableHaveAPublicNoArgConstructor() {
        this.facetFactory.process(MyEncodeableWithoutPublicNoArgConstructor.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodeableFacetAbstract encodeableFacet = (EncodeableFacetAbstract)this.facetHolder.getFacet(EncodeableFacet.class);
        EncodeableFacetFactoryTest.assertNull((Object)encodeableFacet);
    }

    public void testEncoderDecoderNameCanBePickedUpFromConfiguration() {
        String className = "org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacetFactoryTest$MyEncodeableWithEncoderDecoderSpecifiedUsingConfiguration";
        this.propertiesConfiguration.add("nakedobjects.reflector.java.facets.encoderDecoder." + this.canonical("org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacetFactoryTest$MyEncodeableWithEncoderDecoderSpecifiedUsingConfiguration") + ".encoderDecoderName", "org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacetFactoryTest$MyEncodeableWithEncoderDecoderSpecifiedUsingConfiguration");
        this.facetFactory.process(MyEncodeableWithEncoderDecoderSpecifiedUsingConfiguration.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodeableFacetAbstract facet = (EncodeableFacetAbstract)this.facetHolder.getFacet(EncodeableFacet.class);
        EncodeableFacetFactoryTest.assertNotNull((Object)facet);
        EncodeableFacetFactoryTest.assertEquals(MyEncodeableWithEncoderDecoderSpecifiedUsingConfiguration.class, (Object)facet.getEncoderDecoderClass());
    }

    public void testNonAnnotatedEncodeableCanPickUpEncoderDecoderFromConfiguration() {
        String className = "org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacetFactoryTest$NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration";
        this.propertiesConfiguration.add("nakedobjects.reflector.java.facets.encoderDecoder." + this.canonical("org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacetFactoryTest$NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration") + ".encoderDecoderName", "org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacetFactoryTest$NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration");
        this.facetFactory.process(NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        EncodeableFacetAbstract facet = (EncodeableFacetAbstract)this.facetHolder.getFacet(EncodeableFacet.class);
        EncodeableFacetFactoryTest.assertNotNull((Object)facet);
        EncodeableFacetFactoryTest.assertEquals(NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration.class, (Object)facet.getEncoderDecoderClass());
    }

    private String canonical(String className) {
        return className.replace('$', '.');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration
    extends EncoderDecoderNoop<NonAnnotatedEncodeableEncoderDecoderSpecifiedUsingConfiguration> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Encodeable
    public static class MyEncodeableWithEncoderDecoderSpecifiedUsingConfiguration
    extends EncoderDecoderNoop<MyEncodeableWithEncoderDecoderSpecifiedUsingConfiguration> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Encodeable(encoderDecoderClass=MyEncodeableWithoutPublicNoArgConstructor.class)
    public static class MyEncodeableWithoutPublicNoArgConstructor
    extends EncoderDecoderNoop<MyEncodeableWithoutPublicNoArgConstructor> {
        MyEncodeableWithoutPublicNoArgConstructor() {
        }

        public MyEncodeableWithoutPublicNoArgConstructor(int value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Encodeable(encoderDecoderClass=MyEncodeableWithoutNoArgConstructor.class)
    public static class MyEncodeableWithoutNoArgConstructor
    extends EncoderDecoderNoop<MyEncodeableWithoutNoArgConstructor> {
        public MyEncodeableWithoutNoArgConstructor(int value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Encodeable(encoderDecoderClass=MyEncodeableUsingEncoderDecoderClass.class)
    public static class MyEncodeableUsingEncoderDecoderClass
    extends EncoderDecoderNoop<MyEncodeableUsingEncoderDecoderClass> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Encodeable(encoderDecoderName="org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacetFactoryTest$MyEncodeableUsingEncoderDecoderName")
    public static class MyEncodeableUsingEncoderDecoderName
    extends EncoderDecoderNoop<MyEncodeableUsingEncoderDecoderName> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class EncoderDecoderNoop<T>
    implements EncoderDecoder<T> {
        EncoderDecoderNoop() {
        }

        public T fromEncodedString(String encodedString) {
            return null;
        }

        public String toEncodedString(T toEncode) {
            return null;
        }
    }
}

