/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.ident.icon;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.ident.icon.IconFacet;
import org.nakedobjects.metamodel.facets.object.ident.icon.IconFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.ident.icon.IconMethodFacetFactory;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class IconMethodFacetFactoryTest
extends AbstractFacetFactoryTest {
    private IconMethodFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new IconMethodFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        IconMethodFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        IconMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        IconMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        IconMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        IconMethodFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testIconNameMethodPickedUpOnClassAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public String iconName() {
                return null;
            }
        }
        Method iconNameMethod = this.findMethod(Customer.class, "iconName");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(IconFacet.class);
        IconMethodFacetFactoryTest.assertNotNull((Object)facet);
        IconMethodFacetFactoryTest.assertTrue((boolean)(facet instanceof IconFacetViaMethod));
        IconMethodFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(iconNameMethod));
    }
}

