/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.parseable;

import org.nakedobjects.applib.adapters.Parser;
import org.nakedobjects.applib.annotation.Parseable;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.config.prop.PropertiesConfiguration;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacet;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacetAbstract;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacetFactory;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class ParseableFacetFactoryTest
extends AbstractFacetFactoryTest {
    private ParseableFacetFactory facetFactory;
    private PropertiesConfiguration propertiesConfiguration;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new ParseableFacetFactory();
        this.propertiesConfiguration = new PropertiesConfiguration();
        this.facetFactory.setNakedObjectConfiguration((NakedObjectConfiguration)this.propertiesConfiguration);
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        ParseableFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        ParseableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        ParseableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        ParseableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        ParseableFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testFacetPickedUp() {
        this.facetFactory.process(MyParseableUsingParserName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ParseableFacet facet = (ParseableFacet)this.facetHolder.getFacet(ParseableFacet.class);
        ParseableFacetFactoryTest.assertNotNull((Object)facet);
        ParseableFacetFactoryTest.assertTrue((boolean)(facet instanceof ParseableFacetAbstract));
    }

    public void testFacetFacetHolderStored() {
        this.facetFactory.process(MyParseableUsingParserName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ParseableFacetAbstract parseableFacet = (ParseableFacetAbstract)this.facetHolder.getFacet(ParseableFacet.class);
        ParseableFacetFactoryTest.assertEquals((Object)this.facetHolder, (Object)parseableFacet.getFacetHolder());
    }

    public void testNoMethodsRemoved() {
        this.facetFactory.process(MyParseableUsingParserName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        this.assertNoMethodsRemoved();
    }

    public void testParseableUsingParserName() {
        this.facetFactory.process(MyParseableUsingParserName.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ParseableFacetAbstract parseableFacet = (ParseableFacetAbstract)this.facetHolder.getFacet(ParseableFacet.class);
        ParseableFacetFactoryTest.assertEquals(MyParseableUsingParserName.class, (Object)parseableFacet.getParserClass());
    }

    public void testParseableUsingParserClass() {
        this.facetFactory.process(MyParseableUsingParserClass.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ParseableFacetAbstract parseableFacet = (ParseableFacetAbstract)this.facetHolder.getFacet(ParseableFacet.class);
        ParseableFacetFactoryTest.assertEquals(MyParseableUsingParserClass.class, (Object)parseableFacet.getParserClass());
    }

    public void testParseableMustBeAParser() {
    }

    public void testParseableHaveANoArgConstructor() {
        this.facetFactory.process(MyParseableWithoutNoArgConstructor.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ParseableFacetAbstract parseableFacet = (ParseableFacetAbstract)this.facetHolder.getFacet(ParseableFacet.class);
        ParseableFacetFactoryTest.assertNull((Object)parseableFacet);
    }

    public void testParseableHaveAPublicNoArgConstructor() {
        this.facetFactory.process(MyParseableWithoutPublicNoArgConstructor.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ParseableFacetAbstract parseableFacet = (ParseableFacetAbstract)this.facetHolder.getFacet(ParseableFacet.class);
        ParseableFacetFactoryTest.assertNull((Object)parseableFacet);
    }

    public void testParserNameCanBePickedUpFromConfiguration() {
        String className = "org.nakedobjects.metamodel.facets.object.parseable.ParseableFacetFactoryTest$MyParseableWithParserSpecifiedUsingConfiguration";
        this.propertiesConfiguration.add("nakedobjects.reflector.java.facets.parser." + this.canonical("org.nakedobjects.metamodel.facets.object.parseable.ParseableFacetFactoryTest$MyParseableWithParserSpecifiedUsingConfiguration") + ".parserName", "org.nakedobjects.metamodel.facets.object.parseable.ParseableFacetFactoryTest$MyParseableWithParserSpecifiedUsingConfiguration");
        this.facetFactory.process(MyParseableWithParserSpecifiedUsingConfiguration.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ParseableFacetAbstract facet = (ParseableFacetAbstract)this.facetHolder.getFacet(ParseableFacet.class);
        ParseableFacetFactoryTest.assertNotNull((Object)facet);
        ParseableFacetFactoryTest.assertEquals(MyParseableWithParserSpecifiedUsingConfiguration.class, (Object)facet.getParserClass());
    }

    public void testNonAnnotatedParseableCanPickUpParserFromConfiguration() {
        String className = "org.nakedobjects.metamodel.facets.object.parseable.ParseableFacetFactoryTest$NonAnnotatedParseableParserSpecifiedUsingConfiguration";
        this.propertiesConfiguration.add("nakedobjects.reflector.java.facets.parser." + this.canonical("org.nakedobjects.metamodel.facets.object.parseable.ParseableFacetFactoryTest$NonAnnotatedParseableParserSpecifiedUsingConfiguration") + ".parserName", "org.nakedobjects.metamodel.facets.object.parseable.ParseableFacetFactoryTest$NonAnnotatedParseableParserSpecifiedUsingConfiguration");
        this.facetFactory.process(NonAnnotatedParseableParserSpecifiedUsingConfiguration.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ParseableFacetAbstract facet = (ParseableFacetAbstract)this.facetHolder.getFacet(ParseableFacet.class);
        ParseableFacetFactoryTest.assertNotNull((Object)facet);
        ParseableFacetFactoryTest.assertEquals(NonAnnotatedParseableParserSpecifiedUsingConfiguration.class, (Object)facet.getParserClass());
    }

    private String canonical(String className) {
        return className.replace('$', '.');
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NonAnnotatedParseableParserSpecifiedUsingConfiguration
    extends ParserNoop<NonAnnotatedParseableParserSpecifiedUsingConfiguration> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Parseable
    public static class MyParseableWithParserSpecifiedUsingConfiguration
    extends ParserNoop<MyParseableWithParserSpecifiedUsingConfiguration> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Parseable(parserClass=MyParseableWithoutPublicNoArgConstructor.class)
    public static class MyParseableWithoutPublicNoArgConstructor
    extends ParserNoop<MyParseableWithoutPublicNoArgConstructor> {
        MyParseableWithoutPublicNoArgConstructor() {
            this(0);
        }

        public MyParseableWithoutPublicNoArgConstructor(int value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Parseable(parserClass=MyParseableWithoutNoArgConstructor.class)
    public static class MyParseableWithoutNoArgConstructor
    extends ParserNoop<MyParseableWithoutNoArgConstructor> {
        public MyParseableWithoutNoArgConstructor(int value) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Parseable(parserClass=MyParseableUsingParserClass.class)
    public static class MyParseableUsingParserClass
    extends ParserNoop<MyParseableUsingParserClass> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ParserNoop<T>
    implements Parser<T> {
        public T parseTextEntry(T context, String entry) {
            return null;
        }

        public int typicalLength() {
            return 0;
        }

        public String displayTitleOf(T object) {
            return null;
        }

        public String parseableTitleOf(T existing) {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Parseable(parserName="org.nakedobjects.metamodel.facets.object.parseable.ParseableFacetFactoryTest$MyParseableUsingParserName")
    public static class MyParseableUsingParserName
    extends ParserNoop<MyParseableUsingParserName> {
    }
}

