/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.specification;

import java.lang.reflect.Method;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.propparam.specification.DomainObjectWithMustSatisfyAnnotations;
import org.nakedobjects.metamodel.facets.propparam.specification.DomainObjectWithoutMustSatisfyAnnotations;
import org.nakedobjects.metamodel.facets.propparam.specification.MustSatisfySpecificationFacet;
import org.nakedobjects.metamodel.facets.propparam.specification.MustSatisfySpecificationFacetFactory;

@RunWith(value=JMock.class)
public class MustSatisfySpecificationFacetFactoryProcessParameter {
    private Mockery mockery = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };
    private MustSatisfySpecificationFacetFactory facetFactory;
    private MethodRemover mockMethodRemover;
    private FacetHolder mockFacetHolder;
    private Class<DomainObjectWithoutMustSatisfyAnnotations> domainObjectClassWithoutAnnotation;
    private Class<DomainObjectWithMustSatisfyAnnotations> domainObjectClassWithAnnotation;
    private Method changeLastNameMethodWithout;
    private Method changeLastNameMethodWith;

    @Before
    public void setUp() throws Exception {
        this.facetFactory = new MustSatisfySpecificationFacetFactory();
        this.mockMethodRemover = (MethodRemover)this.mockery.mock(MethodRemover.class);
        this.mockFacetHolder = (FacetHolder)this.mockery.mock(FacetHolder.class);
        this.domainObjectClassWithoutAnnotation = DomainObjectWithoutMustSatisfyAnnotations.class;
        this.domainObjectClassWithAnnotation = DomainObjectWithMustSatisfyAnnotations.class;
        this.changeLastNameMethodWithout = this.domainObjectClassWithoutAnnotation.getMethod("changeLastName", String.class);
        this.changeLastNameMethodWith = this.domainObjectClassWithAnnotation.getMethod("changeLastName", String.class);
    }

    @After
    public void tearDown() throws Exception {
        this.facetFactory = null;
        this.mockMethodRemover = null;
        this.mockFacetHolder = null;
    }

    @Test
    public void addsAMustSatisfySpecificationFacetIfAnnotated() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FacetHolder)this.one(MustSatisfySpecificationFacetFactoryProcessParameter.this.mockFacetHolder)).addFacet((Facet)this.with(NofMatchers.anInstanceOf(MustSatisfySpecificationFacet.class)));
            }
        });
        this.facetFactory.processParams(this.changeLastNameMethodWith, 0, this.mockFacetHolder);
    }

    @Test
    public void doesNotAddsAMustSatisfySpecificationFacetIfNotAnnotated() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((FacetHolder)this.never(MustSatisfySpecificationFacetFactoryProcessParameter.this.mockFacetHolder)).addFacet((Facet)this.with(NofMatchers.anInstanceOf(MustSatisfySpecificationFacet.class)));
            }
        });
        this.facetFactory.processParams(this.changeLastNameMethodWithout, 0, this.mockFacetHolder);
    }
}

