/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.specification;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.legacy.ClassImposteriser;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.propparam.specification.MustSatisfySpecificationFacet;
import org.nakedobjects.metamodel.facets.propparam.specification.SpecificationRequiresFirstLetterToBeUpperCase;
import org.nakedobjects.metamodel.facets.propparam.specification.Utils;
import org.nakedobjects.metamodel.interactions.PropertyModifyContext;
import org.nakedobjects.metamodel.interactions.ValidityContext;
import org.nakedobjects.metamodel.spec.identifier.Identified;

@RunWith(value=JMock.class)
public class MustSatisfySpecificationValidatingInteractionMore {
    private final Mockery mockery = new JUnit4Mockery(){
        {
            this.setImposteriser(ClassImposteriser.INSTANCE);
        }
    };
    private MustSatisfySpecificationFacet facetForSpecificationFirstLetterUpperCase;
    private FacetHolder mockHolder;
    private PropertyModifyContext mockContext;
    private NakedObject mockProposedNakedObject;
    private SpecificationRequiresFirstLetterToBeUpperCase requiresFirstLetterToBeUpperCase;

    @Before
    public void setUp() throws Exception {
        this.mockHolder = (FacetHolder)this.mockery.mock(Identified.class);
        this.requiresFirstLetterToBeUpperCase = new SpecificationRequiresFirstLetterToBeUpperCase();
        this.facetForSpecificationFirstLetterUpperCase = new MustSatisfySpecificationFacet(Utils.listOf(this.requiresFirstLetterToBeUpperCase), this.mockHolder);
        this.mockContext = (PropertyModifyContext)this.mockery.mock(PropertyModifyContext.class);
        this.mockProposedNakedObject = (NakedObject)this.mockery.mock(NakedObject.class, "proposed");
    }

    @After
    public void tearDown() throws Exception {
        this.mockHolder = null;
        this.requiresFirstLetterToBeUpperCase = null;
        this.mockContext = null;
    }

    @Test
    public void validatesUsingSpecificationIfProposedOkay() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((PropertyModifyContext)this.one(MustSatisfySpecificationValidatingInteractionMore.this.mockContext)).getProposed();
                this.will(2.returnValue((Object)MustSatisfySpecificationValidatingInteractionMore.this.mockProposedNakedObject));
                ((NakedObject)this.one(MustSatisfySpecificationValidatingInteractionMore.this.mockProposedNakedObject)).getObject();
                this.will(2.returnValue((Object)"This starts with an upper case letter and so is okay"));
            }
        });
        String reason = this.facetForSpecificationFirstLetterUpperCase.invalidates((ValidityContext)this.mockContext);
        Assert.assertThat((Object)reason, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void invalidatesUsingSpecificationIfProposedNotOkay() {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((PropertyModifyContext)this.one(MustSatisfySpecificationValidatingInteractionMore.this.mockContext)).getProposed();
                this.will(3.returnValue((Object)MustSatisfySpecificationValidatingInteractionMore.this.mockProposedNakedObject));
                ((NakedObject)this.one(MustSatisfySpecificationValidatingInteractionMore.this.mockProposedNakedObject)).getObject();
                this.will(3.returnValue((Object)"this starts with an lower case letter and so is not okay"));
            }
        });
        String reason = this.facetForSpecificationFirstLetterUpperCase.invalidates((ValidityContext)this.mockContext);
        Assert.assertThat((Object)reason, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)reason, (Matcher)CoreMatchers.is((Object)"Must start with upper case"));
    }
}

