/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.specification;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.nakedobjects.applib.spec.Specification;
import org.nakedobjects.applib.spec.SpecificationOr;
import org.nakedobjects.metamodel.facets.propparam.specification.SpecificationAlwaysSatisfied;
import org.nakedobjects.metamodel.facets.propparam.specification.SpecificationNeverSatisfied;

public class SpecificationOrTests {
    private Specification alwaysSatisfied = new SpecificationAlwaysSatisfied();
    private Specification neverSatisfied = new SpecificationNeverSatisfied();

    @Test
    public void satisfiedIfNone() {
        class MySpecOr
        extends SpecificationOr {
            public MySpecOr() {
                super(new Specification[0]);
            }
        }
        MySpecOr mySpecOr = new MySpecOr();
        Assert.assertThat((Object)mySpecOr.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void satisfiedIfOneAndOkay() {
        class MySpecOr
        extends SpecificationOr {
            public MySpecOr() {
                super(new Specification[]{SpecificationOrTests.this.alwaysSatisfied});
            }
        }
        MySpecOr mySpecOr = new MySpecOr();
        Assert.assertThat((Object)mySpecOr.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void notSatisfiedIfOneAndNotOkay() {
        class MySpecOr
        extends SpecificationOr {
            public MySpecOr() {
                super(new Specification[]{SpecificationOrTests.this.neverSatisfied});
            }
        }
        MySpecOr mySpecOr = new MySpecOr();
        Assert.assertThat((Object)mySpecOr.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)mySpecOr.satisfies(null), (Matcher)CoreMatchers.is((Object)"not satisfied"));
    }

    @Test
    public void satisfiedIfTwoAndOneIsNotOkay() {
        class MySpecOr
        extends SpecificationOr {
            public MySpecOr() {
                super(new Specification[]{SpecificationOrTests.this.alwaysSatisfied, SpecificationOrTests.this.neverSatisfied});
            }
        }
        MySpecOr mySpecOr = new MySpecOr();
        Assert.assertThat((Object)mySpecOr.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void satisfiedIfTwoAndBothAreOkay() {
        class MySpecOr
        extends SpecificationOr {
            public MySpecOr() {
                super(new Specification[]{SpecificationOrTests.this.alwaysSatisfied, SpecificationOrTests.this.alwaysSatisfied});
            }
        }
        MySpecOr mySpecOr = new MySpecOr();
        Assert.assertThat((Object)mySpecOr.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
    }

    @Test
    public void notSatisfiedIfTwoAndBothAreNotOkayWithConcatenatedReason() {
        class MySpecOr
        extends SpecificationOr {
            public MySpecOr() {
                super(new Specification[]{SpecificationOrTests.this.neverSatisfied, SpecificationOrTests.this.neverSatisfied});
            }
        }
        MySpecOr mySpecOr = new MySpecOr();
        Assert.assertThat((Object)mySpecOr.satisfies(null), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Assert.assertThat((Object)mySpecOr.satisfies(null), (Matcher)CoreMatchers.is((Object)"not satisfied; not satisfied"));
    }
}

