/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.propparam.validate.mask;

import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.Mask;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.propparam.validate.mask.MaskAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.propparam.validate.mask.MaskFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.mask.MaskFacetAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class MaskAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private MaskAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new MaskAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        MaskAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        MaskAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        MaskAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        MaskAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        MaskAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testMaskAnnotationPickedUpOnClass() {
        @Mask(value="###")
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MaskFacet.class);
        MaskAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        MaskAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof MaskFacetAnnotation));
        MaskFacetAnnotation maskFacet = (MaskFacetAnnotation)facet;
        MaskAnnotationFacetFactoryTest.assertEquals((String)"###", (String)maskFacet.value());
    }

    public void testMaskAnnotationPickedUpOnProperty() {
        class Customer {
            Customer() {
            }

            @Mask(value="###")
            public String getFirstName() {
                return null;
            }
        }
        Method method = this.findMethod(Customer.class, "getFirstName");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MaskFacet.class);
        MaskAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        MaskAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof MaskFacetAnnotation));
        MaskFacetAnnotation maskFacet = (MaskFacetAnnotation)facet;
        MaskAnnotationFacetFactoryTest.assertEquals((String)"###", (String)maskFacet.value());
    }

    public void testMaskAnnotationPickedUpOnActionParameter() {
        class Customer {
            Customer() {
            }

            public void someAction(@Mask(value="###") String foo) {
            }
        }
        Method method = this.findMethod(Customer.class, "someAction", new Class[]{String.class});
        this.facetFactory.processParams(method, 0, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(MaskFacet.class);
        MaskAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        MaskAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof MaskFacetAnnotation));
        MaskFacetAnnotation maskFacet = (MaskFacetAnnotation)facet;
        MaskAnnotationFacetFactoryTest.assertEquals((String)"###", (String)maskFacet.value());
    }

    public void testMaskAnnotationNotIgnoredForNonStringsProperty() {
        class Customer {
            Customer() {
            }

            @Mask(value="###")
            public int getNumberOfOrders() {
                return 0;
            }
        }
        Method method = this.findMethod(Customer.class, "getNumberOfOrders");
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        MaskAnnotationFacetFactoryTest.assertNotNull((Object)this.facetHolder.getFacet(MaskFacet.class));
    }

    public void testMaskAnnotationNotIgnoredForPrimitiveOnActionParameter() {
        class Customer {
            Customer() {
            }

            public void someAction(@Mask(value="###") int foo) {
            }
        }
        Method method = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE});
        this.facetFactory.processParams(method, 0, (FacetHolder)this.facetHolder);
        MaskAnnotationFacetFactoryTest.assertNotNull((Object)this.facetHolder.getFacet(MaskFacet.class));
    }
}

