/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.integration.junit4.JMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.BooleanValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.BooleanWrapperValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class BooleanValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private BooleanValueSemanticsProviderAbstract value;
    private Object booleanObj;
    private FacetHolder facetHolder;

    @Before
    public void setUpObjects() throws Exception {
        this.booleanObj = new Boolean(true);
        this.facetHolder = new FacetHolderImpl();
        this.value = new BooleanWrapperValueSemanticsProvider(this.facetHolder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testParseFalseString() throws Exception {
        Object parsed = this.value.parseTextEntry(null, "faLSe");
        Assert.assertEquals((Object)new Boolean(false), (Object)parsed);
    }

    @Test
    public void testParseTrueString() throws Exception {
        Object parsed = this.value.parseTextEntry(null, "TRue");
        Assert.assertEquals((Object)new Boolean(true), (Object)parsed);
    }

    @Test
    public void testParseInvalidString() throws Exception {
        try {
            this.value.parseTextEntry(null, "yes");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTitle() throws Exception {
        Assert.assertEquals((Object)"True", (Object)this.value.displayTitleOf(this.booleanObj));
    }

    @Test
    public void testTitleWhenNotSet() throws Exception {
        Assert.assertEquals((Object)"", (Object)this.value.titleString(null));
    }

    @Test
    public void testEncode() throws Exception {
        Assert.assertEquals((Object)"T", (Object)this.value.toEncodedString(this.booleanObj));
    }

    @Test
    public void testDecode() throws Exception {
        Object parsed = this.value.fromEncodedString("T");
        Assert.assertEquals((Object)new Boolean(true), (Object)parsed);
    }

    @Test
    public void testIsSet() {
        this.allowMockAdapterToReturn(new Boolean(true));
        Assert.assertEquals((Object)true, (Object)this.value.isSet(this.mockAdapter));
    }

    @Test
    public void testIsNotSet() {
        this.allowMockAdapterToReturn(new Boolean(false));
        Assert.assertEquals((Object)false, (Object)this.value.isSet(this.mockAdapter));
    }
}

