/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.sql.Date;
import java.util.Calendar;
import java.util.TimeZone;
import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.value.TestClock;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.JavaSqlDateValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class JavaSqlDateValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private JavaSqlDateValueSemanticsProvider adapter;
    private Date date;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(JavaSqlDateValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.date");
                this.will(1.returnValue(null));
            }
        });
        TestClock.initialize();
        this.date = new Date(0L);
        this.holder = new FacetHolderImpl();
        this.adapter = new JavaSqlDateValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext){

            protected String defaultFormat() {
                return "iso";
            }
        };
        this.setValue((ValueSemanticsProviderAbstract)this.adapter);
    }

    @Test
    public void testInvalidParse() throws Exception {
        try {
            this.adapter.parseTextEntry(null, "date");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTitleOf() {
        Assert.assertEquals((Object)"1970-01-01", (Object)this.adapter.displayTitleOf((Object)this.date));
    }

    @Test
    public void testParse() throws Exception {
        Object newValue = this.adapter.parseTextEntry(null, "1/1/1980");
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("Etc/UTC"));
        calendar.set(1980, 0, 1, 0, 0, 0);
        calendar.set(14, 0);
        Assert.assertEquals((Object)calendar.getTime(), (Object)newValue);
    }
}

