/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.LongValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.LongWrapperValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class LongValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private LongValueSemanticsProviderAbstract value;
    private Object longObj;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.longObj = new Long(367322L);
        this.allowMockAdapterToReturn(this.longObj);
        this.holder = new FacetHolderImpl();
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(LongValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.long");
                this.will(1.returnValue(null));
            }
        });
        this.value = new LongWrapperValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testInvalidParse() throws Exception {
        try {
            this.value.parseTextEntry(null, "one");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testOutputAsString() {
        Assert.assertEquals((Object)"367,322", (Object)this.value.displayTitleOf(this.longObj));
    }

    @Test
    public void testParse() throws Exception {
        Object parsed = this.value.parseTextEntry(null, "120");
        Assert.assertEquals((Object)"120", (Object)parsed.toString());
    }

    @Test
    public void testParseWithBadlyFormattedEntry() throws Exception {
        Object parsed = this.value.parseTextEntry(null, "1,20.0");
        Assert.assertEquals((Object)"120", (Object)parsed.toString());
    }

    @Test
    public void testEncode() throws Exception {
        Assert.assertEquals((Object)"367322", (Object)this.value.toEncodedString(this.longObj));
    }

    @Test
    public void test() throws Exception {
        Object parsed = this.value.fromEncodedString("234");
        Assert.assertEquals((Object)"234", (Object)parsed.toString());
    }
}

