/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.integration.junit4.JMock;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.value.MultilineString;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.MultilineStringValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class MultiLineStringValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private MultilineStringValueSemanticsProvider value;
    private Object multilineString;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.setupSpecification(MultilineString.class);
        this.multilineString = new MultilineString("text entry");
        this.holder = new FacetHolderImpl();
        this.value = new MultilineStringValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testTitleOf() {
        Assert.assertEquals((Object)"text entry", (Object)this.value.displayTitleOf(this.multilineString));
    }

    @Test
    public void testParse() throws Exception {
        Object parsed = this.value.parseTextEntry(this.multilineString, "tRUe");
        Assert.assertEquals((Object)"tRUe", (Object)parsed.toString());
    }

    @Test
    public void testEncodeNormalString() throws Exception {
        Assert.assertEquals((Object)"text entry", (Object)this.value.toEncodedString(this.multilineString));
    }

    @Test
    public void testStringWithSlash() throws Exception {
        this.allowMockAdapterToReturn(new MultilineString("/slash"));
        Assert.assertEquals((Object)"//slash", (Object)this.getEncodeableFacet().toEncodedString(this.mockAdapter));
    }

    @Test
    public void testEncodeNULLString() throws Exception {
        this.allowMockAdapterToReturn(new MultilineString("NULL"));
        Assert.assertEquals((Object)"/NULL", (Object)this.getEncodeableFacet().toEncodedString(this.mockAdapter));
    }

    @Test
    public void testRestore() throws Exception {
        Object restored = this.value.fromEncodedString("//slash");
        Assert.assertEquals((Object)"/slash", (Object)((MultilineString)restored).toString());
    }

    @Test
    public void testRestoreNULLString() throws Exception {
        Object restored = this.value.fromEncodedString("/NULL");
        Assert.assertEquals((Object)"NULL", (Object)((MultilineString)restored).toString());
    }
}

