/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.adapters.EncodingException;
import org.nakedobjects.applib.value.TestClock;
import org.nakedobjects.applib.value.Time;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.TimeValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class TimeValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private TimeValueSemanticsProvider adapter;
    private Time time;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(TimeValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.time");
                this.will(1.returnValue(null));
            }
        });
        TestClock.initialize();
        this.setupSpecification(Time.class);
        this.time = new Time(8, 13);
        this.holder = new FacetHolderImpl();
        this.adapter = new TimeValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.adapter);
    }

    @Test
    public void testTimeAsEncodedString() throws Exception {
        Assert.assertEquals((Object)"081300000", (Object)new String(this.adapter.toEncodedString((Object)this.time)));
    }

    @Test
    public void testParseEntryOfHoursAfterTime() throws Exception {
        Object parsed = this.adapter.parseTextEntry((Object)this.time, "+5H");
        Assert.assertEquals((Object)new Time(13, 13), (Object)parsed);
    }

    @Test
    public void testParseEntryOfHoursAfterNow() throws Exception {
        Object parsed = this.adapter.parseTextEntry(null, "+5H");
        Assert.assertEquals((Object)new Time(2, 30), (Object)parsed);
    }

    @Test
    public void testParseEntryOfHoursBeforeTime() throws Exception {
        Object parsed = this.adapter.parseTextEntry((Object)this.time, "-7H");
        Assert.assertEquals((Object)new Time(1, 13), (Object)parsed);
    }

    @Test
    public void testParseEntryOfHoursBeforeToNow() throws Exception {
        Object parsed = this.adapter.parseTextEntry(null, "-5H");
        Assert.assertEquals((Object)new Time(16, 30), (Object)parsed);
    }

    @Test
    public void testParseEntryOfKeywordNow() throws Exception {
        Object parsed = this.adapter.parseTextEntry((Object)this.time, "now");
        Assert.assertEquals((Object)new Time(), (Object)parsed);
    }

    @Test
    public void testRestoreTime() throws Exception {
        Object parsed = this.adapter.fromEncodedString("213000000");
        Assert.assertEquals((Object)new Time(21, 30), (Object)parsed);
    }

    @Test
    public void testRestoreOfInvalidDatal() throws Exception {
        try {
            this.adapter.fromEncodedString("two ten");
            Assert.fail();
        }
        catch (EncodingException encodingException) {
            // empty catch block
        }
    }
}

