/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.integration.junit4.JMock;
import org.jmock.integration.junit4.JUnit4Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.applib.adapters.EncoderDecoder;
import org.nakedobjects.applib.adapters.Parser;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacet;
import org.nakedobjects.metamodel.facets.object.encodeable.EncodeableFacetUsingEncoderDecoder;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacet;
import org.nakedobjects.metamodel.facets.object.parseable.ParseableFacetUsingParser;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.testutil.ReturnArgumentJMockAction;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=JMock.class)
public abstract class ValueSemanticsProviderAbstractTestCase {
    protected Mockery mockery = new JUnit4Mockery();
    private ValueSemanticsProviderAbstract value;
    private EncodeableFacetUsingEncoderDecoder encodeableFacet;
    private ParseableFacetUsingParser parseableFacet;
    protected FacetHolder mockFacetHolder;
    protected NakedObjectConfiguration mockConfiguration;
    protected SpecificationLoader mockSpecificationLoader;
    protected RuntimeContext mockRuntimeContext;
    protected NakedObject mockAdapter;

    @Before
    public void setUp() throws Exception {
        this.mockFacetHolder = (FacetHolder)this.mockery.mock(FacetHolder.class);
        this.mockRuntimeContext = (RuntimeContext)this.mockery.mock(RuntimeContext.class);
        this.mockSpecificationLoader = (SpecificationLoader)this.mockery.mock(SpecificationLoader.class);
        this.mockConfiguration = (NakedObjectConfiguration)this.mockery.mock(NakedObjectConfiguration.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(ValueSemanticsProviderAbstractTestCase.this.mockConfiguration)).getString((String)this.with(1.any(String.class)), (String)this.with(1.any(String.class)));
                this.will(ReturnArgumentJMockAction.returnArgument(1));
                ((NakedObjectConfiguration)this.allowing(ValueSemanticsProviderAbstractTestCase.this.mockConfiguration)).getBoolean((String)this.with(1.any(String.class)), this.with(1.any(Boolean.class)));
                this.will(ReturnArgumentJMockAction.returnArgument(1));
                ((NakedObjectConfiguration)this.allowing(ValueSemanticsProviderAbstractTestCase.this.mockConfiguration)).getString("nakedobjects.locale");
                this.will(1.returnValue(null));
                ((RuntimeContext)this.allowing(ValueSemanticsProviderAbstractTestCase.this.mockRuntimeContext)).injectDependenciesInto(this.with(1.any(Object.class)));
            }
        });
        this.mockAdapter = (NakedObject)this.mockery.mock(NakedObject.class);
    }

    @After
    public void tearDown() throws Exception {
        this.mockery.assertIsSatisfied();
    }

    protected void allowMockAdapterToReturn(final Object pojo) {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObject)this.allowing(ValueSemanticsProviderAbstractTestCase.this.mockAdapter)).getObject();
                this.will(2.returnValue((Object)pojo));
            }
        });
    }

    protected void setValue(ValueSemanticsProviderAbstract value) {
        this.value = value;
        this.encodeableFacet = new EncodeableFacetUsingEncoderDecoder((EncoderDecoder)value, this.mockFacetHolder, this.mockRuntimeContext);
        this.parseableFacet = new ParseableFacetUsingParser((Parser)value, this.mockFacetHolder, this.mockRuntimeContext);
    }

    protected ValueSemanticsProviderAbstract getValue() {
        return this.value;
    }

    protected EncodeableFacet getEncodeableFacet() {
        return this.encodeableFacet;
    }

    protected ParseableFacet getParseableFacet() {
        return this.parseableFacet;
    }

    protected void setupSpecification(Class<?> type) {
    }

    protected NakedObject createAdapter(Object object) {
        return this.mockAdapter;
    }

    @Test
    public void testParseNull() throws Exception {
        try {
            this.value.parseTextEntry(null, null);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testParseEmptyString() throws Exception {
        Object newValue = this.value.parseTextEntry(null, "");
        Assert.assertNull((Object)newValue);
    }

    @Test
    public void testDecodeNULL() throws Exception {
        NakedObject newValue = this.encodeableFacet.fromEncodedString(EncodeableFacetUsingEncoderDecoder.ENCODED_NULL);
        Assert.assertNull((Object)newValue);
    }

    @Test
    public void testEmptyEncoding() {
        Assert.assertEquals((Object)EncodeableFacetUsingEncoderDecoder.ENCODED_NULL, (Object)this.encodeableFacet.toEncodedString(null));
    }

    @Test
    public void testTitleOfForNullObject() {
        Assert.assertEquals((Object)"", (Object)this.value.displayTitleOf(null));
    }
}

