/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.adapter.version;

import java.util.Date;
import org.nakedobjects.metamodel.adapter.version.Version;
import org.nakedobjects.metamodel.adapter.version.VersionAbstract;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.encoding.ByteEncoder;
import org.nakedobjects.metamodel.commons.encoding.Encodable;
import org.nakedobjects.metamodel.commons.lang.ToString;

public class SerialNumberVersion
extends VersionAbstract
implements Encodable {
    private final long versionNumber;

    public SerialNumberVersion(long number, String user, Date time) {
        super(user, time);
        this.versionNumber = number;
    }

    public SerialNumberVersion(ByteDecoder decoder) {
        super(decoder.getString(), new Date(decoder.getLong()));
        this.versionNumber = decoder.getLong();
    }

    public void encode(ByteEncoder encoder) {
        encoder.add(this.user);
        encoder.add(this.time.getTime());
        encoder.add(this.versionNumber);
    }

    public boolean different(Version version) {
        if (version instanceof SerialNumberVersion) {
            SerialNumberVersion other = (SerialNumberVersion)version;
            return this.versionNumber != other.versionNumber;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof SerialNumberVersion) {
            return !this.different((SerialNumberVersion)obj);
        }
        return false;
    }

    public long getSequence() {
        return this.versionNumber;
    }

    public int hashCode() {
        return (int)(this.versionNumber ^ this.versionNumber >>> 32);
    }

    protected VersionAbstract next() {
        return new SerialNumberVersion(this.versionNumber + 1L, null, null);
    }

    public String sequence() {
        return Long.toString(this.versionNumber, 16);
    }

    public String toString() {
        return "SerialNumberVersion#" + this.versionNumber + " " + ToString.timestamp(this.time);
    }
}

