/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.debug;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;

public class DebugString {
    private static final int COLUMN_SPACING = 25;
    private static final int INDENT_WIDTH = 3;
    private static final String LINE = "-------------------------------------------------------------------------------";
    private static final int MAX_LINE_LENGTH = LINE.length();
    private static final int MAX_SPACES_LENGTH = "                                                                            ".length();
    private static final String SPACES = "                                                                            ";
    private int indent = 0;
    private int section = 1;
    private final StringBuffer string = new StringBuffer();
    private boolean newLine = true;

    public void append(int number, int width) {
        this.appendIndent();
        int len = this.string.length();
        this.string.append(number);
        this.regularizeWidth(width, len);
    }

    public void append(Object object) {
        if (object instanceof DebugInfo) {
            this.indent();
            this.appendTitle(((DebugInfo)object).debugTitle());
            ((DebugInfo)object).debugData(this);
            this.unindent();
        } else {
            this.appendIndent();
            this.string.append(object);
        }
    }

    public void append(Object object, int width) {
        this.appendIndent();
        int len = this.string.length();
        this.string.append(object);
        this.regularizeWidth(width, len);
    }

    public void appendAsHexln(String label, long value) {
        this.appendln(label, "#" + Long.toHexString(value));
    }

    public void appendException(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream s = new PrintStream(baos);
        e.printStackTrace(s);
        this.appendln(e.getMessage());
        this.appendln(new String(baos.toByteArray()));
        s.close();
    }

    public void appendln() {
        this.string.append('\n');
        this.newLine = true;
    }

    public void appendln(String text) {
        this.appendIndent();
        this.append(text);
        this.appendln();
        this.newLine = true;
    }

    public void appendln(String label, boolean value) {
        this.appendln(label, String.valueOf(value));
    }

    public void appendln(String label, double value) {
        this.appendln(label, String.valueOf(value));
    }

    public void appendln(String label, long value) {
        this.appendln(label, String.valueOf(value));
    }

    public void appendln(String label, Object object) {
        this.appendIndent();
        this.string.append(label);
        int spaces = 25 - label.length();
        this.string.append(": " + this.spaces(spaces > 0 ? spaces : 0));
        this.string.append(object);
        this.string.append('\n');
        this.newLine = true;
    }

    public void appendln(String label, Object[] object) {
        if (object.length == 0) {
            this.appendln(label, "empty array");
        } else {
            this.appendln(label, object[0]);
            for (int i = 1; i < object.length; ++i) {
                this.string.append(this.spaces(27));
                this.string.append(object[i]);
                this.string.append('\n');
            }
            this.newLine = true;
        }
    }

    public void appendTitle(String title) {
        this.appendln();
        String titleString = this.section++ + ". " + title;
        this.appendln(titleString);
        String underline = LINE.substring(0, Math.min(MAX_LINE_LENGTH, titleString.length()));
        this.appendln(underline);
    }

    public void startSection(String title) {
        this.appendTitle(title);
        this.indent();
    }

    public void endSection() {
        this.appendln();
        this.unindent();
    }

    public void blankLine() {
        boolean hasLineEnding;
        int length = this.string.length();
        if (length == 0) {
            return;
        }
        boolean bl = hasLineEnding = this.string.charAt(length - 1) == '\n';
        if (!hasLineEnding) {
            this.string.append('\n');
            this.string.append('\n');
            this.newLine = true;
        } else {
            boolean hasDoubleLineEnding;
            boolean bl2 = hasDoubleLineEnding = length >= 2 && this.string.charAt(length - 2) != '\n';
            if (hasDoubleLineEnding) {
                this.string.append('\n');
                this.newLine = true;
            }
        }
    }

    public void indent() {
        ++this.indent;
    }

    private void appendIndent() {
        if (this.newLine) {
            String spaces = this.spaces(Math.min(MAX_SPACES_LENGTH, this.indent * 3));
            this.string.append(spaces);
            this.newLine = false;
        }
    }

    private void regularizeWidth(int width, int len) {
        if (width > 0) {
            int textWidth = this.string.length() - len;
            if (textWidth > width) {
                this.string.setLength(len + width - 3);
                this.string.append("...");
            } else {
                int spaces = width - textWidth;
                spaces = Math.max(0, spaces);
                this.string.append(SPACES.substring(0, spaces));
            }
        }
    }

    private String spaces(int spaces) {
        return SPACES.substring(0, spaces);
    }

    public String toString() {
        return this.string.toString();
    }

    public void unindent() {
        if (this.indent > 0) {
            --this.indent;
        }
    }
}

