/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.encoding;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.nakedobjects.metamodel.commons.encoding.ByteDecoder;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;

public class ByteDecoderBuffer
implements ByteDecoder {
    private final InputStream input;

    public ByteDecoderBuffer(InputStream input) {
        this.input = input;
    }

    public String getString() {
        int len = this.getByte();
        byte[] val = new byte[len];
        try {
            int read = this.input.read(val);
            if (read != len) {
                throw new NakedObjectException("failed to read all of string: " + new String(val) + ", " + this.input.available() + " bytes still available");
            }
        }
        catch (IOException e) {
            throw new NakedObjectException(e);
        }
        return new String(val);
    }

    public int getByte() {
        try {
            return this.input.read();
        }
        catch (IOException e) {
            throw new NakedObjectException(e);
        }
    }

    public byte[] getBytes() {
        int len = this.getByte();
        try {
            byte[] array = new byte[len];
            this.input.read(array);
            return array;
        }
        catch (IOException e) {
            throw new NakedObjectException(e);
        }
    }

    public String[] getList() {
        int len = this.getByte();
        String[] list = new String[len];
        for (int i = 0; i < list.length; ++i) {
            list[i] = this.getString();
        }
        return list;
    }

    public long getLong() {
        return Long.valueOf(this.getString());
    }

    public boolean getBoolean() {
        return this.getByte() == 1;
    }

    public Object getObject() {
        Class<?> cls;
        String className = this.getString();
        if (className.equals("null")) {
            return null;
        }
        if (className.equals("true")) {
            return Boolean.TRUE;
        }
        if (className.equals("false")) {
            return Boolean.FALSE;
        }
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            throw new NakedObjectException("failed to find class " + className, e);
        }
        if (className.startsWith("[")) {
            cls = cls.getComponentType();
            int len = this.getInt();
            Object[] array = (Object[])Array.newInstance(cls, len);
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.getObject();
            }
            return array;
        }
        Constructor<?> constructor = null;
        try {
            constructor = cls.getConstructor(ByteDecoder.class);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (constructor != null) {
            try {
                return constructor.newInstance(this);
            }
            catch (IllegalArgumentException e) {
                throw new NakedObjectException(e);
            }
            catch (InstantiationException e) {
                throw new NakedObjectException(e);
            }
            catch (IllegalAccessException e) {
                throw new NakedObjectException(e);
            }
            catch (InvocationTargetException e) {
                throw new NakedObjectException(e);
            }
        }
        if (Serializable.class.isAssignableFrom(cls)) {
            byte[] bytes = this.getBytes();
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            try {
                ObjectInputStream ois = new ObjectInputStream(bais);
                return ois.readObject();
            }
            catch (IOException e) {
                throw new NakedObjectException(e);
            }
            catch (ClassNotFoundException e) {
                throw new NakedObjectException(e);
            }
        }
        throw new NakedObjectException("failed to decode object as either Encodable or Serializable");
    }

    public Object[] getObjects() {
        String arrayClass = this.getString();
        if (arrayClass.equals("null-array")) {
            return null;
        }
        return this.createArray(arrayClass);
    }

    private Object[] createArray(String arrayClass) {
        try {
            int len = this.getInt();
            Class<?> cls = Class.forName(arrayClass);
            Object[] array = (Object[])Array.newInstance(cls, len);
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.getObject();
            }
            return array;
        }
        catch (ClassNotFoundException e) {
            throw new NakedObjectException(e);
        }
    }

    public int getInt() {
        return Integer.valueOf(this.getString());
    }

    public void end() {
        try {
            int available = this.input.available();
            if (available > 0) {
                byte[] leftOver = new byte[available];
                this.input.read(leftOver);
                throw new NakedObjectException("more data available after completion of read: " + new String(leftOver));
            }
        }
        catch (IOException e) {
            throw new NakedObjectException(e);
        }
    }
}

