/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.commons.logging;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Logger {
    private String fileName;
    private DateFormat format;
    private boolean logAlso = true;
    private org.apache.log4j.Logger logger;
    private boolean showTime = true;
    private final long start = this.time();
    private PrintStream stream;

    public Logger() {
        this.format = new SimpleDateFormat("yyyyMMdd-hhmm-ss.SSS");
    }

    public Logger(String fileName, boolean logAlso) {
        this();
        this.fileName = fileName;
        this.logAlso = logAlso;
    }

    public void close() {
        if (this.stream != null) {
            this.stream.close();
        }
    }

    protected abstract Class<?> getDecoratedClass();

    public boolean isLogToFile() {
        return this.fileName != null;
    }

    public boolean isLogToLog4j() {
        return this.logAlso;
    }

    public void log(String message) {
        if (this.logAlso) {
            this.logger().info((Object)message);
        }
        if (this.fileName != null) {
            if (this.stream == null) {
                try {
                    if (this.fileName == null) {
                        return;
                    }
                    this.stream = new PrintStream(new FileOutputStream(this.fileName));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (this.showTime) {
                this.stream.print(this.format.format(new Date(this.time())));
            } else {
                this.stream.print(this.time() - this.start);
            }
            this.stream.print("  ");
            this.stream.println(message);
            this.stream.flush();
        }
    }

    public void log(String request, Object result) {
        this.log(request + "  -> " + result);
    }

    private org.apache.log4j.Logger logger() {
        if (this.logger == null) {
            this.logger = org.apache.log4j.Logger.getLogger(this.getDecoratedClass());
        }
        return this.logger;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setLogAlso(boolean logAlso) {
        this.logAlso = logAlso;
    }

    public void setShowTime(boolean showTime) {
        this.showTime = showTime;
    }

    public void setTimeFormat(String format) {
        this.format = new SimpleDateFormat(format);
    }

    private long time() {
        return System.currentTimeMillis();
    }
}

