/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.config.reader.propfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.log4j.Logger;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.reader.ConfigurationReader;

public class PropertiesFileReader
implements ConfigurationReader {
    private static final Logger LOG = Logger.getLogger(PropertiesFileReader.class);
    private final Properties properties = new Properties();
    private boolean found = false;

    public PropertiesFileReader(String directory, String fileName, boolean ensureFileLoads) {
        File file = new File(directory, fileName);
        try {
            FileInputStream in = new FileInputStream(file);
            this.properties.load(in);
            this.found = true;
            LOG.info((Object)("configuration file " + file.getPath() + " loaded"));
        }
        catch (FileNotFoundException e) {
            if (ensureFileLoads) {
                throw new NakedObjectException("Could not find required configuration file: " + file.getPath());
            }
            LOG.info((Object)("configuration file " + file.getPath() + " not found, but not needed"));
        }
        catch (IOException e) {
            throw new NakedObjectException("Could not load configuration file " + file.getPath(), e);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }

    public boolean isFound() {
        return this.found;
    }
}

