/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.config.reader.propfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.reader.ConfigurationReader;

public class PropertiesFilesReader
implements ConfigurationReader {
    private final Properties properties = new Properties();
    private final boolean ensureFileLoads;

    public PropertiesFilesReader(boolean ensureFileLoads) {
        this.ensureFileLoads = ensureFileLoads;
    }

    public PropertiesFilesReader(String pathname, boolean ensureFileLoads) {
        this(ensureFileLoads);
        this.loadProperties(pathname);
    }

    public void loadProperties(String pathname) {
        try {
            File file = new File(pathname);
            FileInputStream in = new FileInputStream(file);
            this.properties.load(in);
        }
        catch (FileNotFoundException e) {
            if (this.ensureFileLoads) {
                throw new NakedObjectException("Could not find required configuration file: " + pathname);
            }
        }
        catch (IOException e) {
            throw new NakedObjectException("Could not load configuration file: " + pathname, e);
        }
    }

    public Properties getProperties() {
        return this.properties;
    }
}

