/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facetdecorator;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.nakedobjects.metamodel.commons.component.ApplicationScopedComponent;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.exceptions.ReflectionException;
import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacetDecoratorSet
implements ApplicationScopedComponent {
    private final Map<Class<? extends Facet>, FacetDecorator> facetDecoratorByFacetType = new HashMap<Class<? extends Facet>, FacetDecorator>();
    private final Set<FacetDecorator> facetDecoratorSet = new LinkedHashSet<FacetDecorator>();

    @Override
    public void init() {
    }

    @Override
    public void shutdown() {
    }

    public void add(FacetDecorator decorator) {
        Class<? extends Facet>[] forFacetTypes = decorator.forFacetTypes();
        for (int i = 0; i < forFacetTypes.length; ++i) {
            this.facetDecoratorByFacetType.put(forFacetTypes[i], decorator);
            this.facetDecoratorSet.add(decorator);
        }
    }

    public void add(List<FacetDecorator> decorators) {
        for (FacetDecorator decorator : decorators) {
            this.add(decorator);
        }
    }

    public Set<FacetDecorator> getFacetDecorators() {
        return Collections.unmodifiableSet(this.facetDecoratorSet);
    }

    public boolean isEmpty() {
        return this.facetDecoratorByFacetType.isEmpty();
    }

    public void decorateAllHoldersFacets(FacetHolder holder) {
        if (this.isEmpty()) {
            return;
        }
        Class<? extends Facet>[] facetTypes = holder.getFacetTypes();
        for (int i = 0; i < facetTypes.length; ++i) {
            Facet originalFacet = holder.getFacet(facetTypes[i]);
            this.decorateFacet(originalFacet, holder);
        }
    }

    private void decorateFacet(Facet facet, FacetHolder holder) {
        Class<? extends Facet> cls = facet.facetType();
        FacetDecorator decorator = this.facetDecoratorByFacetType.get(cls);
        if (decorator == null) {
            return;
        }
        Facet decoratedFacet = decorator.decorate(facet, holder);
        if (decoratedFacet != null) {
            this.ensureAtLeastOneOfTheDecoratingFacetsConsistentWithDecorated(decorator, decoratedFacet);
            facet.setFacetHolder(holder);
            holder.addFacet(decoratedFacet);
        }
    }

    private void ensureAtLeastOneOfTheDecoratingFacetsConsistentWithDecorated(FacetDecorator decorator, Facet decoratedFacet) {
        if (!this.isAtLeastOneOfTheDecoratingFacetsConsistentWithDecorated(decorator, decoratedFacet)) {
            throw new ReflectionException("Inconsistent facet type " + decoratedFacet.getClass() + "; expectected one of " + decorator.getFacetTypeNames());
        }
    }

    private boolean isAtLeastOneOfTheDecoratingFacetsConsistentWithDecorated(FacetDecorator decorator, Facet decoratedFacet) {
        for (Class<? extends Facet> decoratedFacetType : decorator.forFacetTypes()) {
            if (!decoratedFacetType.isAssignableFrom(decoratedFacet.getClass())) continue;
            return true;
        }
        return false;
    }

    public void debugData(DebugString str) {
        str.appendTitle("Facet decorators");
        str.indent();
        Set<Class<? extends Facet>> facetTypes = this.facetDecoratorByFacetType.keySet();
        if (facetTypes.size() == 0) {
            str.append("none");
        } else {
            for (Class<? extends Facet> cls : facetTypes) {
                str.appendln(cls.getName(), this.facetDecoratorByFacetType.get(cls));
            }
        }
        str.unindent();
    }
}

