/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.matchers.NofMatchers;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.spec.identifier.Identified;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FacetAbstract
implements Facet {
    private Facet underlyingFacet;
    private final Class<? extends Facet> facetType;
    private final boolean derived;
    private FacetHolder holder;
    private Identified identified;

    public FacetAbstract(Class<? extends Facet> facetType, FacetHolder holder, boolean derived) {
        this.facetType = Ensure.ensureThatArg(facetType, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue(Class.class))));
        this.setFacetHolder(Ensure.ensureThatArg(holder, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue(FacetHolder.class)))));
        this.derived = derived;
    }

    @Override
    public final Class<? extends Facet> facetType() {
        return this.facetType;
    }

    @Override
    public FacetHolder getFacetHolder() {
        return this.holder;
    }

    @Override
    public boolean isDerived() {
        return this.derived;
    }

    public Identified getIdentified() {
        return this.identified;
    }

    @Override
    public Facet getUnderlyingFacet() {
        return this.underlyingFacet;
    }

    @Override
    public void setUnderlyingFacet(Facet underlyingFacet) {
        Ensure.ensureThatArg(underlyingFacet.facetType(), NofMatchers.classEqualTo(this.facetType));
        this.underlyingFacet = underlyingFacet;
    }

    @Override
    public boolean isNoop() {
        return false;
    }

    @Override
    public boolean alwaysReplace() {
        return true;
    }

    @Override
    public void setFacetHolder(FacetHolder facetHolder) {
        this.holder = facetHolder;
        this.identified = this.holder instanceof Identified ? (Identified)this.holder : null;
    }

    public String toString() {
        String cls = this.getClass().getName();
        String stringValues = this.toStringValues();
        String type = "";
        if (this.getClass() != this.facetType()) {
            String facetType = this.facetType().getName();
            type = "type=" + facetType.substring(facetType.lastIndexOf(46) + 1);
            if (!"".equals(stringValues)) {
                type = type + ",";
            }
        }
        return cls.substring(cls.lastIndexOf(46) + 1) + "[" + type + stringValues + "]";
    }

    public Object unwrapObject(NakedObject nakedObject) {
        if (nakedObject == null) {
            return null;
        }
        return nakedObject.getObject();
    }

    public String unwrapString(NakedObject nakedObject) {
        Object obj = this.unwrapObject(nakedObject);
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof String)) {
            return null;
        }
        return (String)obj;
    }

    protected String toStringValues() {
        return "";
    }
}

