/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.actions;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.nakedobjects.applib.security.UserMemento;
import org.nakedobjects.metamodel.commons.names.NameConvertorUtils;
import org.nakedobjects.metamodel.commons.names.NameUtils;
import org.nakedobjects.metamodel.exceptions.ReflectionException;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetUtil;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.actions.DebugFacetViaNamingConvention;
import org.nakedobjects.metamodel.facets.actions.DescribedAsFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.ExecutedFacetViaNamingConvention;
import org.nakedobjects.metamodel.facets.actions.ExplorationFacetViaNamingConvention;
import org.nakedobjects.metamodel.facets.actions.MandatoryFacetOverriddenByMethod;
import org.nakedobjects.metamodel.facets.actions.NamedFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.choices.ActionChoicesFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.choices.ActionParameterChoicesFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.defaults.ActionDefaultsFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.defaults.ActionParameterDefaultsFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.executed.ExecutedFacet;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.validate.ActionValidationFacetViaMethod;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacetInferred;
import org.nakedobjects.metamodel.java5.MethodPrefixBasedFacetFactoryAbstract;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContextAware;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaNakedObjectActionPeer;
import org.nakedobjects.metamodel.util.InvokeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionMethodsFacetFactory
extends MethodPrefixBasedFacetFactoryAbstract
implements RuntimeContextAware {
    private static final String EXPLORATION_PREFIX = "Exploration";
    private static final String DEBUG_PREFIX = "Debug";
    private static final String REMOTE_PREFIX = "Remote";
    private static final String LOCAL_PREFIX = "Local";
    private static final String PARAMETER_NAMES_PREFIX = "names";
    private static final String PARAMETER_DESCRIPTIONS_PREFIX = "descriptions";
    private static final String PARAMETER_OPTIONAL_PREFIX = "optional";
    private static final String PARAMETER_DEFAULTS_PREFIX = "default";
    private static final String PARAMETER_CHOICES_PREFIX = "choices";
    private static final String[] PREFIXES = new String[]{"Exploration", "Debug", "Remote", "Local", "names", "descriptions", "optional", "default", "choices"};
    private RuntimeContext runtimeContext;

    public ActionMethodsFacetFactory() {
        super(PREFIXES, NakedObjectFeatureType.ACTIONS_ONLY);
    }

    @Override
    public boolean process(Method actionMethod, MethodRemover methodRemover, FacetHolder action) {
        String capitalizedName = NameUtils.capitalizeName(actionMethod.getName());
        Class<?> type = actionMethod.getDeclaringClass();
        Class<?> returnType = actionMethod.getReturnType();
        Class<?>[] paramTypes = actionMethod.getParameterTypes();
        ArrayList<Facet> facets = new ArrayList<Facet>();
        NakedObjectSpecification typeSpec = this.getSpecificationLoader().loadSpecification(type);
        NakedObjectSpecification returnSpec = this.getSpecificationLoader().loadSpecification(returnType.getName());
        if (returnSpec != null) {
            facets.add(new ActionInvocationFacetViaMethod(actionMethod, typeSpec, returnSpec, action, this.getRuntimeContext()));
            this.checkForDebugPrefix(facets, capitalizedName, action);
            this.checkForExplorationPrefix(facets, capitalizedName, action);
            this.checkForExecutionLocationPrefix(facets, capitalizedName, action);
        }
        this.removeMethod(methodRemover, actionMethod);
        boolean forClass = (actionMethod.getModifiers() & 8) > 0;
        this.findAndRemoveValidMethod(facets, methodRemover, type, forClass, capitalizedName, returnType, paramTypes, action);
        boolean oldChoicesOrDefaultsMethodsUsed = this.findAndRemoveParametersDefaultsMethod(facets, methodRemover, type, forClass, capitalizedName, returnType, paramTypes, action);
        oldChoicesOrDefaultsMethodsUsed = this.findAndRemoveParametersChoicesMethod(facets, methodRemover, type, forClass, capitalizedName, returnType, paramTypes, action) || oldChoicesOrDefaultsMethodsUsed;
        this.defaultNamedFacet(facets, methodRemover, capitalizedName, action);
        this.findAndRemoveNameMethod(facets, methodRemover, type, capitalizedName, new Class[0], action);
        this.findAndRemoveDescriptionMethod(facets, methodRemover, type, capitalizedName, new Class[0], action);
        this.findAndRemoveAlwaysHideMethod(facets, methodRemover, type, capitalizedName, paramTypes, action);
        this.findAndRemoveProtectMethod(facets, methodRemover, type, capitalizedName, paramTypes, action);
        this.findAndRemoveHideForSessionMethod(facets, methodRemover, type, capitalizedName, UserMemento.class, action);
        this.findAndRemoveDisableForSessionMethod(facets, methodRemover, type, capitalizedName, UserMemento.class, action);
        this.findAndRemoveHideMethod(facets, methodRemover, type, forClass, capitalizedName, paramTypes, action);
        this.findAndRemoveDisableMethod(facets, methodRemover, type, forClass, capitalizedName, paramTypes, action);
        if (action instanceof JavaNakedObjectActionPeer) {
            JavaNakedObjectActionPeer javaNakedObjectActionPeer = (JavaNakedObjectActionPeer)action;
            FacetHolder[] actionParameters = javaNakedObjectActionPeer.getParameters();
            this.findAndRemoveOptionalForActionParametersMethod(methodRemover, type, capitalizedName, returnType, paramTypes, actionParameters);
            this.findAndRemoveNamesForActionParametersMethod(methodRemover, type, capitalizedName, returnType, paramTypes, actionParameters);
            this.findAndRemoveDescriptionsforActionParametersMethod(methodRemover, type, capitalizedName, returnType, paramTypes, actionParameters);
            this.findAndRemoveChoicesForActionParametersMethod(oldChoicesOrDefaultsMethodsUsed, methodRemover, type, capitalizedName, paramTypes, actionParameters);
            this.findAndRemoveDefaultForActionParametersMethod(oldChoicesOrDefaultsMethodsUsed, methodRemover, type, capitalizedName, paramTypes, actionParameters);
        }
        return FacetUtil.addFacets(facets);
    }

    private void checkForExecutionLocationPrefix(List<Facet> actionFacets, String capitalizedName, FacetHolder action) {
        if (capitalizedName.startsWith(LOCAL_PREFIX)) {
            actionFacets.add(new ExecutedFacetViaNamingConvention(ExecutedFacet.Where.LOCALLY, action));
        } else if (capitalizedName.startsWith(REMOTE_PREFIX)) {
            actionFacets.add(new ExecutedFacetViaNamingConvention(ExecutedFacet.Where.REMOTELY, action));
        }
    }

    private void checkForDebugPrefix(List<Facet> actionFacets, String capitalizedName, FacetHolder action) {
        if (capitalizedName.startsWith(DEBUG_PREFIX)) {
            actionFacets.add(new DebugFacetViaNamingConvention(action));
        }
    }

    private void checkForExplorationPrefix(List<Facet> facets, String capitalizedName, FacetHolder action) {
        if (capitalizedName.startsWith(EXPLORATION_PREFIX)) {
            facets.add(new ExplorationFacetViaNamingConvention(action));
        }
    }

    private void defaultNamedFacet(List<Facet> actionFacets, MethodRemover methodRemover, String capitalizedName, FacetHolder action) {
        String name = this.removePrefix(capitalizedName, LOCAL_PREFIX);
        name = this.removePrefix(name, REMOTE_PREFIX);
        name = this.removePrefix(name, DEBUG_PREFIX);
        name = this.removePrefix(name, EXPLORATION_PREFIX);
        name = this.removePrefix(name, LOCAL_PREFIX);
        name = this.removePrefix(name, REMOTE_PREFIX);
        name = NameConvertorUtils.naturalName(name);
        actionFacets.add(new NamedFacetInferred(name, action));
    }

    private void findAndRemoveValidMethod(List<Facet> actionFacets, MethodRemover methodRemover, Class<?> cls, boolean onClass, String capitalizedName, Class<?> returnType, Class<?>[] params, FacetHolder action) {
        Method method = this.findMethod(cls, onClass, "validate" + capitalizedName, String.class, params);
        if (method == null) {
            return;
        }
        this.removeMethod(methodRemover, method);
        actionFacets.add(new ActionValidationFacetViaMethod(method, action));
    }

    private boolean findAndRemoveParametersDefaultsMethod(List<Facet> actionFacets, MethodRemover methodRemover, Class<?> cls, boolean onClass, String capitalizedName, Class<?> returnType, Class<?>[] params, FacetHolder action) {
        if (params.length == 0) {
            return false;
        }
        Method method = null;
        String name = PARAMETER_DEFAULTS_PREFIX + capitalizedName;
        if (this.allParametersOfSameType(params)) {
            Object array = Array.newInstance(params[0], 0);
            Class<?> classes = array.getClass();
            method = this.findMethodWithOrWithoutParameters(cls, onClass, name, classes, params);
            this.removeMethod(methodRemover, method);
        }
        if (method == null) {
            method = this.findMethodWithOrWithoutParameters(cls, onClass, name, Object[].class, params);
            this.removeMethod(methodRemover, method);
        }
        if (method == null) {
            method = this.findMethodWithOrWithoutParameters(cls, onClass, name, List.class, params);
            this.removeMethod(methodRemover, method);
        }
        if (method == null) {
            return false;
        }
        actionFacets.add(new ActionDefaultsFacetViaMethod(method, action));
        return true;
    }

    private boolean findAndRemoveParametersChoicesMethod(List<Facet> actionFacets, MethodRemover methodRemover, Class<?> cls, boolean onClass, String capitalizedName, Class<?> returnType, Class<?>[] params, FacetHolder action) {
        if (params.length <= 0) {
            return false;
        }
        Method method = null;
        String name = PARAMETER_CHOICES_PREFIX + capitalizedName;
        if (this.allParametersOfSameType(params)) {
            Object array = Array.newInstance(params[0], 0, 0);
            Class<?> classes = array.getClass();
            method = this.findMethodWithOrWithoutParameters(cls, onClass, name, classes, params);
            this.removeMethod(methodRemover, method);
        }
        if (method == null) {
            method = this.findMethodWithOrWithoutParameters(cls, onClass, name, Object[].class, params);
            this.removeMethod(methodRemover, method);
        }
        if (method == null) {
            method = this.findMethodWithOrWithoutParameters(cls, onClass, name, List.class, params);
            this.removeMethod(methodRemover, method);
        }
        if (method == null) {
            return false;
        }
        actionFacets.add(new ActionChoicesFacetViaMethod(method, returnType, action, this.getSpecificationLoader(), this.getRuntimeContext()));
        return true;
    }

    private void findAndRemoveOptionalForActionParametersMethod(MethodRemover methodRemover, Class<?> cls, String capitalizedName, Class<?> returnType, Class<?>[] params, FacetHolder[] parameters) {
        if (params.length == 0) {
            return;
        }
        Method method = this.findMethodWithOrWithoutParameters(cls, true, PARAMETER_OPTIONAL_PREFIX + capitalizedName, boolean[].class, params);
        if (method == null) {
            return;
        }
        this.removeMethod(methodRemover, method);
        Object[] parameterObjects = new Object[method.getParameterTypes().length];
        boolean[] names = (boolean[])InvokeUtils.invokeStatic(method, parameterObjects);
        for (int i = 0; i < names.length; ++i) {
            if (!names[i]) continue;
            FacetUtil.addFacet(new MandatoryFacetOverriddenByMethod(parameters[i]));
        }
    }

    private void findAndRemoveNamesForActionParametersMethod(MethodRemover methodRemover, Class<?> cls, String capitalizedName, Class<?> returnType, Class<?>[] params, FacetHolder[] parameters) {
        Method method = this.findMethodWithOrWithoutParameters(cls, true, PARAMETER_NAMES_PREFIX + capitalizedName, String[].class, params);
        if (method == null) {
            return;
        }
        this.removeMethod(methodRemover, method);
        Object[] parameterObjects = new Object[method.getParameterTypes().length];
        String[] names = (String[])InvokeUtils.invokeStatic(method, parameterObjects);
        if (names.length != parameters.length) {
            throw new ReflectionException("Invalid number of parameter names, expected " + parameters.length + ", but got " + names.length + ", on " + method);
        }
        for (int i = 0; i < names.length; ++i) {
            FacetUtil.addFacet(new NamedFacetViaMethod(names[i], method, parameters[i]));
        }
    }

    private void findAndRemoveChoicesForActionParametersMethod(boolean oldChoicesOrDefaultsMethodsUsed, MethodRemover methodRemover, Class<?> cls, String capitalizedName, Class<?>[] params, FacetHolder[] parameters) {
        for (int i = 0; i < params.length; ++i) {
            Class<?> returnType = Array.newInstance(params[i], 0).getClass();
            String name = PARAMETER_CHOICES_PREFIX + i + capitalizedName;
            Method method = this.findMethodWithOrWithoutParameters(cls, false, name, returnType, null);
            if (method == null) {
                method = this.findMethodWithOrWithoutParameters(cls, false, name, List.class, null);
            }
            if (method == null) continue;
            if (oldChoicesOrDefaultsMethodsUsed) {
                throw new ReflectionException(cls + " uses both old and new choices/default syntax - must use one or other");
            }
            this.removeMethod(methodRemover, method);
            FacetUtil.addFacet(new ActionParameterChoicesFacetViaMethod(method, returnType, parameters[i], this.getSpecificationLoader(), this.getRuntimeContext()));
        }
    }

    private void findAndRemoveDefaultForActionParametersMethod(boolean oldChoicesOrDefaultsMethodsUsed, MethodRemover methodRemover, Class<?> cls, String capitalizedName, Class<?>[] params, FacetHolder[] parameters) {
        for (int i = 0; i < params.length; ++i) {
            Method method = this.findMethodWithOrWithoutParameters(cls, false, PARAMETER_DEFAULTS_PREFIX + i + capitalizedName, params[i], null);
            if (method == null) continue;
            if (oldChoicesOrDefaultsMethodsUsed) {
                throw new ReflectionException(cls + " uses both old and new choices/default syntax - must use one or other");
            }
            this.removeMethod(methodRemover, method);
            FacetUtil.addFacet(new ActionParameterDefaultsFacetViaMethod(method, parameters[i]));
        }
    }

    private void findAndRemoveDescriptionsforActionParametersMethod(MethodRemover methodRemover, Class<?> cls, String capitalizedName, Class<?> returnType, Class<?>[] params, FacetHolder[] parameters) {
        Method method = this.findMethodWithOrWithoutParameters(cls, true, PARAMETER_DESCRIPTIONS_PREFIX + capitalizedName, String[].class, params);
        if (method == null) {
            return;
        }
        this.removeMethod(methodRemover, method);
        Object[] parameterObjects = new Object[method.getParameterTypes().length];
        String[] names = (String[])InvokeUtils.invokeStatic(method, parameterObjects);
        for (int i = 0; i < names.length; ++i) {
            FacetUtil.addFacet(new DescribedAsFacetViaMethod(names[i], method, parameters[i]));
        }
        methodRemover.removeMethod(method);
    }

    private String removePrefix(String name, String prefix) {
        if (name.startsWith(prefix)) {
            return name.substring(prefix.length());
        }
        return name;
    }

    private boolean allParametersOfSameType(Class<?>[] params) {
        Class<?> firstParam = params[0];
        for (int i = 1; i < params.length; ++i) {
            if (params[i] == firstParam) continue;
            return false;
        }
        return true;
    }

    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }
}

