/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.actions.choices;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.commons.lang.ArrayUtils;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.actions.choices.ActionChoicesFacetAbstract;
import org.nakedobjects.metamodel.java5.ImperativeFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.util.NakedObjectAdapterUtils;
import org.nakedobjects.metamodel.util.NakedObjectInvokeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionChoicesFacetViaMethod
extends ActionChoicesFacetAbstract
implements ImperativeFacet {
    private final Method method;
    private final Class<?> choicesType;
    private final RuntimeContext runtimeContext;
    private final SpecificationLoader specificationLoader;

    public ActionChoicesFacetViaMethod(Method method, Class<?> choicesType, FacetHolder holder, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(holder);
        this.method = method;
        this.choicesType = choicesType;
        this.specificationLoader = specificationLoader;
        this.runtimeContext = runtimeContext;
    }

    @Override
    public List<Method> getMethods() {
        return Collections.singletonList(this.method);
    }

    @Override
    public Object[][] getChoices(NakedObject owningAdapter) {
        Object[] options = (Object[])NakedObjectInvokeUtils.invoke(this.method, owningAdapter);
        Object[][] results = new Object[options.length][];
        for (int i = 0; i < results.length; ++i) {
            if (options[i] == null) {
                results[i] = null;
                continue;
            }
            if (options.getClass().isArray()) {
                results[i] = ArrayUtils.getObjectAsObjectArray(options[i]);
                continue;
            }
            NakedObjectSpecification specification = this.getSpecificationLoader().loadSpecification(this.choicesType);
            results[i] = NakedObjectAdapterUtils.getCollectionAsObjectArray(options[i], specification, this.getRuntimeContext());
        }
        return results;
    }

    private RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    protected String toStringValues() {
        return "method=" + this.method + ",type=" + this.choicesType;
    }

    private SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }
}

