/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.collections;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.nakedobjects.applib.security.UserMemento;
import org.nakedobjects.metamodel.commons.lang.StringUtils;
import org.nakedobjects.metamodel.commons.names.NameUtils;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetUtil;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.MethodScope;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromSupportingMethods;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacetViaAccessor;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacetViaMethod;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionClearFacetViaAccessor;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionClearFacetViaMethod;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacetViaAccessor;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacetViaMethod;
import org.nakedobjects.metamodel.facets.collections.validate.CollectionValidateAddToFacetViaMethod;
import org.nakedobjects.metamodel.facets.collections.validate.CollectionValidateRemoveFromFacetViaMethod;
import org.nakedobjects.metamodel.facets.propcoll.access.PropertyAccessorFacetViaAccessor;
import org.nakedobjects.metamodel.facets.properties.choices.PropertyChoicesFacetViaMethod;
import org.nakedobjects.metamodel.java5.PropertyOrCollectionIdentifyingFacetFactoryAbstract;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContextAware;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaOneToManyAssociationPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollectionFieldMethodsFacetFactory
extends PropertyOrCollectionIdentifyingFacetFactoryAbstract
implements RuntimeContextAware {
    private static final Logger LOG = Logger.getLogger(CollectionFieldMethodsFacetFactory.class);
    private static final String REMOVE_FROM_PREFIX = "removeFrom";
    private static final String ADD_TO_PREFIX = "addTo";
    protected static final String CLEAR_PREFIX = "clear";
    protected static final String GET_PREFIX = "get";
    protected static final String MODIFY_PREFIX = "modify";
    protected static final String SET_PREFIX = "set";
    private static final String OPTIONAL_PREFIX = "optional";
    private static final String VALIDATE_ADD_TO_PREFIX = "validateaddTo";
    private static final String VALIDATE_ADD_TO_PREFIX_2 = "validate" + StringUtils.capitalize("addTo");
    private static final String VALIDATE_REMOVE_FROM_PREFIX = "validateremoveFrom";
    private static final String VALIDATE_REMOVE_FROM_PREFIX_2 = "validate" + StringUtils.capitalize("removeFrom");
    private static final String[] PREFIXES = new String[]{"removeFrom", "addTo", "clear", "get", "modify", "set", "optional", "validateaddTo", "validateremoveFrom"};
    private RuntimeContext runtimeContext;

    public CollectionFieldMethodsFacetFactory() {
        super(PREFIXES, NakedObjectFeatureType.COLLECTIONS_ONLY);
    }

    @Override
    public boolean process(Method collectionAccessor, MethodRemover methodRemover, FacetHolder collection) {
        String capitalizedName = NameUtils.javaBaseName(collectionAccessor.getName());
        Class<?> returnType = collectionAccessor.getReturnType();
        Class<?> cls = collectionAccessor.getDeclaringClass();
        ArrayList<Facet> facets = new ArrayList<Facet>();
        this.removeMethod(methodRemover, collectionAccessor);
        facets.add(new PropertyAccessorFacetViaAccessor(collectionAccessor, collection));
        Class<?> addToType = this.findAndRemoveAddToMethod(facets, methodRemover, cls, collectionAccessor, capitalizedName, collection);
        Class<?> removeFromType = this.findAndRemoveRemoveFromMethod(facets, methodRemover, cls, collectionAccessor, capitalizedName, collection);
        Class<?> collectionType = this.inferTypeOfIfPossible(facets, collectionAccessor, addToType, removeFromType, collection);
        this.findAndRemoveClearMethod(facets, methodRemover, cls, collectionAccessor, capitalizedName, collection);
        this.findAndRemoveValidateAddToMethod(facets, methodRemover, cls, collectionType, capitalizedName, returnType, collection);
        this.findAndRemoveValidateRemoveFromMethod(facets, methodRemover, cls, collectionType, capitalizedName, returnType, collection);
        this.findAndRemoveNameMethod(facets, methodRemover, cls, capitalizedName, collection);
        this.findAndRemoveDescriptionMethod(facets, methodRemover, cls, capitalizedName, collection);
        this.findAndRemoveAlwaysHideMethod(facets, methodRemover, cls, capitalizedName, collection);
        this.findAndRemoveProtectMethod(facets, methodRemover, cls, capitalizedName, collection);
        this.findAndRemoveHideForSessionMethod(facets, methodRemover, cls, capitalizedName, UserMemento.class, collection);
        this.findAndRemoveDisableForSessionMethod(facets, methodRemover, cls, capitalizedName, UserMemento.class, collection);
        this.findAndRemoveHideMethod(facets, methodRemover, cls, false, capitalizedName, collection);
        this.findAndRemoveDisableMethod(facets, methodRemover, cls, false, capitalizedName, collection);
        return FacetUtil.addFacets(facets);
    }

    private Class<?> findAndRemoveAddToMethod(List<Facet> collectionFacets, MethodRemover methodRemover, Class<?> cls, Method getMethod, String capitalizedName, FacetHolder collection) {
        Class<?> addType;
        Method method = this.findMethod(cls, false, ADD_TO_PREFIX + capitalizedName, Void.TYPE);
        this.removeMethod(methodRemover, method);
        Class<?> clazz = addType = method == null || method.getParameterTypes().length != 1 ? null : method.getParameterTypes()[0];
        if (method != null) {
            collectionFacets.add(new CollectionAddToFacetViaMethod(method, collection));
        } else {
            collectionFacets.add(new CollectionAddToFacetViaAccessor(getMethod, collection, this.getRuntimeContext()));
        }
        return addType;
    }

    private Class<?> findAndRemoveRemoveFromMethod(List<Facet> collectionFacets, MethodRemover methodRemover, Class<?> cls, Method getMethod, String capitalizedName, FacetHolder collection) {
        Class<?> removeType;
        Method method = this.findMethod(cls, false, REMOVE_FROM_PREFIX + capitalizedName, Void.TYPE);
        this.removeMethod(methodRemover, method);
        Class<?> clazz = removeType = method == null || method.getParameterTypes().length != 1 ? null : method.getParameterTypes()[0];
        if (method != null) {
            collectionFacets.add(new CollectionRemoveFromFacetViaMethod(method, collection));
        } else {
            collectionFacets.add(new CollectionRemoveFromFacetViaAccessor(getMethod, collection, this.getRuntimeContext()));
        }
        return removeType;
    }

    private void findAndRemoveClearMethod(List<Facet> collectionFacets, MethodRemover methodRemover, Class<?> cls, Method getMethod, String capitalizedName, FacetHolder collection) {
        Method method = this.findMethod(cls, false, CLEAR_PREFIX + capitalizedName, Void.TYPE, null);
        this.removeMethod(methodRemover, method);
        if (method != null) {
            collectionFacets.add(new CollectionClearFacetViaMethod(method, collection));
        } else {
            collectionFacets.add(new CollectionClearFacetViaAccessor(getMethod, collection, this.getRuntimeContext()));
        }
    }

    private Class<?> inferTypeOfIfPossible(List<Facet> collectionFacets, Method getMethod, Class<?> addType, Class<?> removeType, FacetHolder collection) {
        Class<?> type = null;
        if (addType != null && removeType != null && addType != removeType) {
            LOG.warn((Object)("The addTo/removeFrom methods " + getMethod.getDeclaringClass() + " must " + "both deal with same type of object: " + addType + "; " + removeType));
            return null;
        }
        Class<?> clazz = type = addType != null ? addType : removeType;
        if (type != null) {
            collectionFacets.add(new TypeOfFacetInferredFromSupportingMethods(type, collection, this.getSpecificationLoader()));
        }
        return type;
    }

    private void findAndRemoveValidateAddToMethod(List<Facet> collectionFacets, MethodRemover methodRemover, Class<?> cls, Class<?> collectionType, String capitalizedName, Class<?> returnType, FacetHolder collection) {
        Method method = this.findMethod(cls, false, VALIDATE_ADD_TO_PREFIX + capitalizedName, String.class, this.paramTypesOrNull(collectionType));
        if (method == null) {
            method = this.findMethod(cls, false, VALIDATE_ADD_TO_PREFIX_2 + capitalizedName, String.class, this.paramTypesOrNull(collectionType));
        }
        if (method == null) {
            return;
        }
        this.removeMethod(methodRemover, method);
        collectionFacets.add(new CollectionValidateAddToFacetViaMethod(method, collection));
    }

    private void findAndRemoveValidateRemoveFromMethod(List<Facet> collectionFacets, MethodRemover methodRemover, Class<?> cls, Class<?> collectionType, String capitalizedName, Class<?> returnType, FacetHolder collection) {
        Method method = this.findMethod(cls, false, VALIDATE_REMOVE_FROM_PREFIX + capitalizedName, String.class, this.paramTypesOrNull(collectionType));
        if (method == null) {
            method = this.findMethod(cls, false, VALIDATE_REMOVE_FROM_PREFIX_2 + capitalizedName, String.class, this.paramTypesOrNull(collectionType));
        }
        if (method == null) {
            return;
        }
        this.removeMethod(methodRemover, method);
        collectionFacets.add(new CollectionValidateRemoveFromFacetViaMethod(method, collection));
    }

    private void findAndRemoveChoicesMethod(List<Facet> collectionFacets, MethodRemover methodRemover, Class<?> cls, String capitalizedName, Class<?> returnType, JavaOneToManyAssociationPeer collection) {
        Method method = this.findMethod(cls, false, "choices" + capitalizedName, Object[].class, NO_PARAMETERS_TYPES);
        this.removeMethod(methodRemover, method);
        if (method == null) {
            return;
        }
        collectionFacets.add(new PropertyChoicesFacetViaMethod(method, returnType, collection, this.getSpecificationLoader(), this.getRuntimeContext()));
    }

    @Override
    public boolean isPropertyOrCollectionAccessorCandidate(Method method) {
        return method.getName().startsWith(GET_PREFIX);
    }

    @Override
    public boolean isCollectionAccessor(Method method) {
        if (!this.isPropertyOrCollectionAccessorCandidate(method)) {
            return false;
        }
        Class<?> methodReturnType = method.getReturnType();
        return this.isCollectionOrArray(methodReturnType);
    }

    @Override
    public boolean isPropertyAccessor(Method method) {
        return false;
    }

    public boolean isValuePropertyAccessor(Method method) {
        return false;
    }

    @Override
    public void findAndRemoveCollectionAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
        Class<?>[] collectionClasses = this.getCollectionTypeRepository().getCollectionType();
        for (int i = 0; i < collectionClasses.length; ++i) {
            Class<?> returnType = collectionClasses[i];
            List<Method> list = methodRemover.removeMethods(MethodScope.OBJECT, GET_PREFIX, returnType, false, 0);
            methodListToAppendTo.addAll(list);
        }
    }

    @Override
    public void findAndRemovePropertyAccessors(MethodRemover methodRemover, List<Method> methodListToAppendTo) {
    }

    private RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }
}

