/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.services;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.applib.DomainObjectContainer;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.lang.CastUtils;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.exceptions.ReflectionException;
import org.nakedobjects.metamodel.services.ServicesInjector;
import org.nakedobjects.metamodel.services.ServicesInjectorAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ServicesInjectorAbstract
implements ServicesInjector {
    private static final Logger LOG = Logger.getLogger(ServicesInjectorAbstract.class);
    private DomainObjectContainer container;
    private final List<Object> services = new ArrayList<Object>();

    @Override
    public void open() {
        this.autowireServicesAndContainer();
    }

    @Override
    public void close() {
    }

    @Override
    public DomainObjectContainer getContainer() {
        return this.container;
    }

    @Override
    public void setContainer(DomainObjectContainer container) {
        Ensure.ensureThatArg(container, CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.container = container;
    }

    @Override
    public void setServices(List<Object> services) {
        this.services.clear();
        this.addServices(services);
        this.autowireServicesAndContainer();
    }

    @Override
    public List<Object> getRegisteredServices() {
        return Collections.unmodifiableList(this.services);
    }

    private void addServices(List<Object> services) {
        for (Object service : services) {
            if (service instanceof List) {
                List<Object> serviceList = CastUtils.listOf(service, Object.class);
                this.addServices(serviceList);
                continue;
            }
            this.addService(service);
        }
    }

    private boolean addService(Object service) {
        return this.services.add(service);
    }

    @Override
    public void injectDependencies(Object object) {
        Assert.assertNotNull("no container", this.container);
        Assert.assertNotNull("no services", this.services);
        ArrayList<Object> servicesCopy = new ArrayList<Object>(this.services);
        servicesCopy.add(this.container);
        ServicesInjectorAbstract.injectServices(object, servicesCopy);
    }

    @Override
    public void injectDependencies(List<Object> objects) {
        for (Object object : objects) {
            this.injectDependencies(object);
        }
    }

    @Override
    public void injectInto(Object candidate) {
        if (ServicesInjectorAware.class.isAssignableFrom(candidate.getClass())) {
            ServicesInjectorAware cast = (ServicesInjectorAware)ServicesInjectorAware.class.cast(candidate);
            cast.setServicesInjector(this);
        }
    }

    private static void injectServices(Object object, List<Object> services) {
        Class<?> cls = object.getClass();
        for (Object service : services) {
            Class<?> serviceClass = service.getClass();
            Method[] methods = cls.getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Class<?>[] parameterTypes;
                if (!methods[j].getName().startsWith("set") || (parameterTypes = methods[j].getParameterTypes()).length != 1 || parameterTypes[0] == Object.class || !parameterTypes[0].isAssignableFrom(serviceClass)) continue;
                ServicesInjectorAbstract.invokeSetMethod(methods[j], object, service);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)("injected service " + service + " into " + new ToString(object)));
            }
        }
    }

    private static void invokeMethod(Method method, Object target, Object[] parameters) {
        try {
            method.invoke(target, parameters);
        }
        catch (SecurityException e) {
            throw new ReflectionException(String.format("Cannot access the %s method in %s", method.getName(), target.getClass().getName()));
        }
        catch (IllegalArgumentException e1) {
            throw new ReflectionException(e1);
        }
        catch (IllegalAccessException e1) {
            throw new ReflectionException(String.format("Cannot access the %s method in %s", method.getName(), target.getClass().getName()));
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            if (targetException instanceof RuntimeException) {
                throw (RuntimeException)targetException;
            }
            throw new ReflectionException(targetException);
        }
    }

    private static void invokeSetMethod(Method set, Object target, Object parameter) {
        Object[] parameters = new Object[]{parameter};
        ServicesInjectorAbstract.invokeMethod(set, target, parameters);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("injected " + parameter + " into " + new ToString(target)));
        }
    }

    private void autowireServicesAndContainer() {
        this.injectDependencies(this.services);
        this.injectDependencies(this.container);
    }
}

