/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.specloader;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.nakedobjects.metamodel.adapter.NakedObjectList;
import org.nakedobjects.metamodel.commons.debug.DebugInfo;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.ensure.Assert;
import org.nakedobjects.metamodel.commons.ensure.Ensure;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.JavaClassUtils;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facetdecorator.FacetDecorator;
import org.nakedobjects.metamodel.facetdecorator.FacetDecoratorSet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.noruntime.RuntimeContextNoRuntime;
import org.nakedobjects.metamodel.spec.IntrospectableSpecification;
import org.nakedobjects.metamodel.spec.JavaSpecification;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.SpecificationFacets;
import org.nakedobjects.metamodel.specloader.NakedObjectReflector;
import org.nakedobjects.metamodel.specloader.SpecificationLoaderAware;
import org.nakedobjects.metamodel.specloader.classsubstitutor.ClassSubstitutor;
import org.nakedobjects.metamodel.specloader.collectiontyperegistry.CollectionTypeRegistry;
import org.nakedobjects.metamodel.specloader.internal.TypeExtractorMethodReturn;
import org.nakedobjects.metamodel.specloader.internal.cache.SimpleSpecificationCache;
import org.nakedobjects.metamodel.specloader.internal.cache.SpecificationCache;
import org.nakedobjects.metamodel.specloader.internal.facetprocessor.FacetProcessor;
import org.nakedobjects.metamodel.specloader.internal.instances.InstanceCollectionSpecification;
import org.nakedobjects.metamodel.specloader.progmodelfacets.ProgrammingModelFacets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NakedObjectReflectorAbstract
implements NakedObjectReflector,
DebugInfo {
    private static final Logger LOG = Logger.getLogger(NakedObjectReflectorAbstract.class);
    private final NakedObjectConfiguration configuration;
    private final ClassSubstitutor classSubstitutor;
    private final CollectionTypeRegistry collectionTypeRegistry;
    private final ProgrammingModelFacets programmingModelFacets;
    private final FacetProcessor facetProcessor;
    private final SpecificationCache cache;
    private final FacetDecoratorSet facetDecoratorSet;
    private RuntimeContext runtimeContext;

    public NakedObjectReflectorAbstract(NakedObjectConfiguration configuration, ClassSubstitutor classSubstitutor, CollectionTypeRegistry collectionTypeRegistry, ProgrammingModelFacets programmingModelFacets, Set<FacetDecorator> facetDecorators) {
        Ensure.ensureThatArg(configuration, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(classSubstitutor, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(collectionTypeRegistry, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(programmingModelFacets, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Ensure.ensureThatArg(facetDecorators, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        this.configuration = configuration;
        this.classSubstitutor = classSubstitutor;
        this.collectionTypeRegistry = collectionTypeRegistry;
        this.programmingModelFacets = programmingModelFacets;
        this.facetDecoratorSet = new FacetDecoratorSet();
        for (FacetDecorator facetDecorator : facetDecorators) {
            this.facetDecoratorSet.add(facetDecorator);
        }
        this.facetProcessor = new FacetProcessor(configuration, this, collectionTypeRegistry, programmingModelFacets);
        this.cache = new SimpleSpecificationCache();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        LOG.info((Object)("finalizing reflector factory " + this));
    }

    @Override
    public void init() {
        LOG.debug((Object)("initialising " + this));
        if (this.runtimeContext == null) {
            this.runtimeContext = new RuntimeContextNoRuntime();
        }
        this.injectInto(this.runtimeContext);
        this.runtimeContext.injectInto(this.facetProcessor);
        this.facetDecoratorSet.init();
        this.classSubstitutor.init();
        this.collectionTypeRegistry.init();
        this.facetProcessor.init();
    }

    @Override
    public void shutdown() {
        LOG.info((Object)("shutting down " + this));
        this.getCache().clear();
        this.facetDecoratorSet.shutdown();
    }

    @Override
    public NakedObjectSpecification loadSpecification(Class<?> type) {
        Class<?> substitutedType = this.getClassSubstitutor().getClass(type);
        return substitutedType != null ? this.loadSpecificationFromCache(substitutedType) : null;
    }

    private NakedObjectSpecification loadSpecificationFromCache(Class<?> type) {
        Assert.assertNotNull(type);
        NakedObjectSpecification spec = this.getCache().get(type.getName());
        if (spec != null) {
            return spec;
        }
        return this.loadSpecificationAndCache(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NakedObjectSpecification loadSpecificationAndCache(Class<?> type) {
        SpecificationCache specificationCache;
        SpecificationCache specificationCache2 = specificationCache = this.getCache();
        synchronized (specificationCache2) {
            NakedObjectSpecification specification = this.createSpecification(type);
            if (specification == null) {
                throw new NakedObjectException("Failed to create specification for class " + type.getName());
            }
            specificationCache.cache(type.getName(), specification);
            if (specification instanceof IntrospectableSpecification) {
                IntrospectableSpecification introspectableSpecification = (IntrospectableSpecification)specification;
                introspectableSpecification.introspect(this.facetDecoratorSet);
            }
            return specification;
        }
    }

    public void loadSpecificationForReturnTypes(Set<Method> methods, Class<?> classToIgnore) {
        for (Method method : methods) {
            for (Class returnType : new TypeExtractorMethodReturn(method)) {
                if (returnType == classToIgnore) continue;
                this.loadSpecification(returnType);
            }
        }
    }

    protected NakedObjectSpecification createSpecification(Class<?> cls) {
        if (NakedObjectList.class.isAssignableFrom(cls)) {
            return new InstanceCollectionSpecification(this, this.getRuntimeContext());
        }
        return new JavaSpecification(cls, this, this.getRuntimeContext());
    }

    @Override
    public final NakedObjectSpecification loadSpecification(String className) {
        Ensure.ensureThatArg(className, CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), "specification class name must be specified");
        try {
            Class<?> cls = this.loadClass(className);
            return this.loadSpecification(cls);
        }
        catch (ClassNotFoundException e) {
            NakedObjectSpecification spec = this.getCache().get(className);
            if (spec == null) {
                throw new NakedObjectException("No such class available: " + className);
            }
            return spec;
        }
    }

    private Class<?> loadClass(String className) throws ClassNotFoundException {
        Class<?> builtIn = JavaClassUtils.getBuiltIn(className);
        if (builtIn != null) {
            return builtIn;
        }
        return Class.forName(className);
    }

    @Override
    public NakedObjectSpecification[] allSpecifications() {
        return this.getCache().allSpecifications();
    }

    @Override
    public boolean loaded(Class<?> cls) {
        return this.loaded(cls.getName());
    }

    @Override
    public boolean loaded(String fullyQualifiedClassName) {
        return this.getCache().get(fullyQualifiedClassName) != null;
    }

    @Override
    public void injectInto(Object candidate) {
        Class<?> candidateClass = candidate.getClass();
        if (SpecificationLoaderAware.class.isAssignableFrom(candidateClass)) {
            SpecificationLoaderAware cast = (SpecificationLoaderAware)SpecificationLoaderAware.class.cast(candidate);
            cast.setSpecificationLoader(this);
        }
        this.getClassSubstitutor().injectInto(candidate);
        this.getCollectionTypeRegistry().injectInto(candidate);
    }

    @Override
    public void debugData(DebugString str) {
        this.facetDecoratorSet.debugData(str);
        str.appendln();
        str.appendTitle("Specifications");
        NakedObjectSpecification[] specs = this.allSpecifications();
        Arrays.sort(specs, new Comparator<NakedObjectSpecification>(){

            @Override
            public int compare(NakedObjectSpecification s1, NakedObjectSpecification s2) {
                return s1.getShortName().compareToIgnoreCase(s2.getShortName());
            }
        });
        for (int i = 0; i < specs.length; ++i) {
            NakedObjectSpecification specification = specs[i];
            str.append(specification.isAbstract() ? "A" : ".");
            str.append(specification.isService() ? "S" : ".");
            str.append(SpecificationFacets.isBoundedSet(specification) ? "B" : ".");
            str.append(specification.isCollection() ? "C" : ".");
            str.append(specification.isObject() ? "O" : ".");
            str.append(".");
            str.append(specification.isParseable() ? "P" : ".");
            str.append(specification.isEncodeable() ? "E" : ".");
            str.append(specification.isAggregated() ? "A" : ".");
            str.append(!specification.isMutableAggregated() ? "I" : ".");
            str.append("  ");
            str.append(specification.getShortName());
            str.append("  [fqc=");
            str.append(specification.getFullName());
            str.append(",type=");
            str.append(specification.getClass().getName());
            str.appendln("]");
        }
    }

    @Override
    public String debugTitle() {
        return "Reflector";
    }

    public FacetProcessor getFacetProcessor() {
        return this.facetProcessor;
    }

    private SpecificationCache getCache() {
        return this.cache;
    }

    @Override
    public RuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    @Override
    public void setRuntimeContext(RuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    public NakedObjectConfiguration getNakedObjectConfiguration() {
        return this.configuration;
    }

    @Override
    public ClassSubstitutor getClassSubstitutor() {
        return this.classSubstitutor;
    }

    public CollectionTypeRegistry getCollectionTypeRegistry() {
        return this.collectionTypeRegistry;
    }

    public ProgrammingModelFacets getProgrammingModelFacets() {
        return this.programmingModelFacets;
    }

    public Set<FacetDecorator> getFacetDecoratorSet() {
        return this.facetDecoratorSet.getFacetDecorators();
    }
}

