/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.specloader.internal;

import java.util.ArrayList;
import java.util.List;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.filters.Filter;
import org.nakedobjects.metamodel.consent.Allow;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.InteractionInvocationMethod;
import org.nakedobjects.metamodel.exceptions.ModelException;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.MultiTypedFacet;
import org.nakedobjects.metamodel.facets.actions.choices.ActionParameterChoicesFacet;
import org.nakedobjects.metamodel.facets.actions.defaults.ActionParameterDefaultsFacet;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsFacet;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacet;
import org.nakedobjects.metamodel.facets.propparam.validate.mandatory.MandatoryFacet;
import org.nakedobjects.metamodel.interactions.ActionArgumentContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.SpecificationFacets;
import org.nakedobjects.metamodel.spec.feature.NakedObjectAction;
import org.nakedobjects.metamodel.spec.feature.NakedObjectActionParameter;
import org.nakedobjects.metamodel.specloader.internal.NakedObjectActionImpl;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectActionParamPeer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class NakedObjectActionParameterAbstract
implements NakedObjectActionParameter {
    private final int number;
    private final NakedObjectActionImpl parentAction;
    private final NakedObjectActionParamPeer peer;

    protected NakedObjectActionParameterAbstract(int number, NakedObjectActionImpl nakedObjectAction, NakedObjectActionParamPeer peer) {
        this.number = number;
        this.parentAction = nakedObjectAction;
        this.peer = peer;
    }

    @Override
    public boolean isObject() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public NakedObjectAction getAction() {
        return this.parentAction;
    }

    @Override
    public NakedObjectSpecification getSpecification() {
        return this.peer.getSpecification();
    }

    @Override
    public Identifier getIdentifier() {
        return this.parentAction.getIdentifier();
    }

    @Override
    public String getName() {
        NamedFacet facet = this.getFacet(NamedFacet.class);
        String name = facet == null ? null : facet.value();
        name = name == null ? this.peer.getSpecification().getSingularName() : name;
        return name;
    }

    @Override
    public String getDescription() {
        DescribedAsFacet facet = this.getFacet(DescribedAsFacet.class);
        String description = facet.value();
        return description == null ? "" : description;
    }

    @Override
    public boolean isOptional() {
        MandatoryFacet facet = this.getFacet(MandatoryFacet.class);
        return facet.isInvertedSemantics();
    }

    public Consent isUsable() {
        return Allow.DEFAULT;
    }

    @Override
    public boolean containsFacet(Class<? extends Facet> facetType) {
        return this.peer != null ? this.peer.containsFacet(facetType) : false;
    }

    @Override
    public <T extends Facet> T getFacet(Class<T> cls) {
        return this.peer != null ? (T)this.peer.getFacet(cls) : null;
    }

    @Override
    public Class<? extends Facet>[] getFacetTypes() {
        return this.peer != null ? this.peer.getFacetTypes() : new Class[]{};
    }

    @Override
    public Facet[] getFacets(Filter<Facet> filter) {
        return this.peer != null ? this.peer.getFacets(filter) : new Facet[]{};
    }

    @Override
    public void addFacet(Facet facet) {
        if (this.peer != null) {
            this.peer.addFacet(facet);
        }
    }

    @Override
    public void addFacet(MultiTypedFacet facet) {
        if (this.peer != null) {
            this.peer.addFacet(facet);
        }
    }

    @Override
    public void removeFacet(Facet facet) {
        if (this.peer != null) {
            this.peer.removeFacet(facet);
        }
    }

    @Override
    public void removeFacet(Class<? extends Facet> facetType) {
        if (this.peer != null) {
            this.peer.removeFacet(facetType);
        }
    }

    @Override
    public ActionArgumentContext createProposedArgumentInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, NakedObject targetObject, NakedObject[] proposedArguments, int position) {
        return new ActionArgumentContext(this.getAuthenticationSession(), invocationMethod, targetObject, this.getIdentifier(), proposedArguments, position);
    }

    @Override
    public NakedObject[] getChoices(NakedObject nakedObject) {
        ArrayList<NakedObject> parameterChoices = new ArrayList<NakedObject>();
        ActionParameterChoicesFacet choicesFacet = this.getFacet(ActionParameterChoicesFacet.class);
        if (choicesFacet != null) {
            Object[] choices = choicesFacet.getChoices(this.parentAction.realTarget(nakedObject));
            NakedObjectActionParameterAbstract.checkChoicesType(this.getRuntimeContext(), choices, this.getSpecification());
            for (Object choice : choices) {
                parameterChoices.add(this.getRuntimeContext().adapterFor(choice));
            }
        }
        if (parameterChoices.size() == 0 && SpecificationFacets.isBoundedSet(this.getSpecification())) {
            List<NakedObject> allInstancesAdapter = this.getRuntimeContext().allInstances(this.getSpecification());
            for (NakedObject adapter : allInstancesAdapter) {
                parameterChoices.add(adapter);
            }
        }
        return parameterChoices.toArray(new NakedObject[0]);
    }

    public static void checkChoicesType(RuntimeContext runtimeContext, Object[] objects, NakedObjectSpecification paramSpec) {
        Class<?> componentType = objects.getClass().getComponentType();
        NakedObjectSpecification componentSpec = runtimeContext.getSpecificationLoader().loadSpecification(componentType);
        if (!componentSpec.isOfType(paramSpec)) {
            throw new ModelException("Choices type incompatible with parameter type; expected " + paramSpec.getFullName() + ", but was " + componentSpec.getFullName());
        }
    }

    @Override
    public NakedObject getDefault(NakedObject nakedObject) {
        if (this.parentAction.isContributed() && nakedObject != null && nakedObject.getSpecification().isOfType(this.getSpecification())) {
            return nakedObject;
        }
        ActionParameterDefaultsFacet defaultsFacet = this.getFacet(ActionParameterDefaultsFacet.class);
        if (defaultsFacet != null) {
            Object dflt = defaultsFacet.getDefault(this.parentAction.realTarget(nakedObject));
            if (dflt == null) {
                return null;
            }
            return this.getRuntimeContext().adapterFor(dflt);
        }
        return null;
    }

    protected RuntimeContext getRuntimeContext() {
        return this.parentAction.getRuntimeContext();
    }

    protected AuthenticationSession getAuthenticationSession() {
        return this.getRuntimeContext().getAuthenticationSession();
    }
}

