/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.specloader.internal;

import org.nakedobjects.metamodel.adapter.Instance;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.authentication.AuthenticationSession;
import org.nakedobjects.metamodel.commons.debug.DebugString;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.consent.Consent;
import org.nakedobjects.metamodel.consent.InteractionInvocationMethod;
import org.nakedobjects.metamodel.consent.InteractionResult;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionClearFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.nakedobjects.metamodel.facets.propcoll.access.PropertyAccessorFacet;
import org.nakedobjects.metamodel.interactions.CollectionAddToContext;
import org.nakedobjects.metamodel.interactions.CollectionRemoveFromContext;
import org.nakedobjects.metamodel.interactions.CollectionUsabilityContext;
import org.nakedobjects.metamodel.interactions.CollectionVisibilityContext;
import org.nakedobjects.metamodel.interactions.InteractionUtils;
import org.nakedobjects.metamodel.interactions.UsabilityContext;
import org.nakedobjects.metamodel.interactions.ValidityContext;
import org.nakedobjects.metamodel.interactions.VisibilityContext;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.runtimecontext.spec.feature.NakedObjectAssociationAbstract;
import org.nakedobjects.metamodel.runtimecontext.spec.feature.NakedObjectMemberAbstract;
import org.nakedobjects.metamodel.spec.feature.OneToManyAssociation;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectAssociationPeer;
import org.nakedobjects.metamodel.util.CollectionFacetUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyAssociationImpl
extends NakedObjectAssociationAbstract
implements OneToManyAssociation {
    private final NakedObjectAssociationPeer reflectiveAdapter;

    public OneToManyAssociationImpl(NakedObjectAssociationPeer association, RuntimeContext runtimeContext) {
        super(association.getIdentifier().getMemberName(), association.getSpecification(), NakedObjectMemberAbstract.MemberType.ONE_TO_MANY_ASSOCIATION, association, runtimeContext);
        this.reflectiveAdapter = association;
    }

    @Override
    public VisibilityContext<?> createVisibleInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, NakedObject ownerAdapter) {
        return new CollectionVisibilityContext(session, invocationMethod, ownerAdapter, this.getIdentifier());
    }

    @Override
    public UsabilityContext<?> createUsableInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, NakedObject ownerAdapter) {
        return new CollectionUsabilityContext(session, invocationMethod, ownerAdapter, this.getIdentifier());
    }

    @Override
    public ValidityContext<?> createValidateAddInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, NakedObject ownerAdapter, NakedObject proposedToAddAdapter) {
        return new CollectionAddToContext(session, invocationMethod, ownerAdapter, this.getIdentifier(), proposedToAddAdapter);
    }

    @Override
    public Consent isValidToAdd(NakedObject ownerAdapter, NakedObject proposedToAddAdapter) {
        return this.isValidToAddResult(ownerAdapter, proposedToAddAdapter).createConsent();
    }

    private InteractionResult isValidToAddResult(NakedObject ownerAdapter, NakedObject proposedToAddAdapter) {
        ValidityContext<?> validityContext = this.createValidateAddInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, ownerAdapter, proposedToAddAdapter);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    @Override
    public ValidityContext<?> createValidateRemoveInteractionContext(AuthenticationSession session, InteractionInvocationMethod invocationMethod, NakedObject ownerAdapter, NakedObject proposedToRemoveAdapter) {
        return new CollectionRemoveFromContext(session, invocationMethod, ownerAdapter, this.getIdentifier(), proposedToRemoveAdapter);
    }

    @Override
    public Consent isValidToRemove(NakedObject ownerAdapter, NakedObject proposedToRemoveAdapter) {
        return this.isValidToRemoveResult(ownerAdapter, proposedToRemoveAdapter).createConsent();
    }

    private InteractionResult isValidToRemoveResult(NakedObject ownerAdapter, NakedObject proposedToRemoveAdapter) {
        ValidityContext<?> validityContext = this.createValidateRemoveInteractionContext(this.getAuthenticationSession(), InteractionInvocationMethod.BY_USER, ownerAdapter, proposedToRemoveAdapter);
        return InteractionUtils.isValidResult(this, validityContext);
    }

    private boolean readWrite() {
        return this.isPersisted();
    }

    @Override
    public NakedObject get(NakedObject ownerAdapter) {
        PropertyAccessorFacet accessor = this.getFacet(PropertyAccessorFacet.class);
        Object collection = accessor.getProperty(ownerAdapter);
        if (collection == null) {
            return null;
        }
        NakedObject collectionAdapter = this.getRuntimeContext().adapterFor(collection, ownerAdapter, this);
        collectionAdapter.setTypeOfFacet(this.getFacet(TypeOfFacet.class));
        return collectionAdapter;
    }

    @Override
    public boolean isEmpty(NakedObject parentAdapter) {
        NakedObject collection = this.get(parentAdapter);
        CollectionFacet facet = CollectionFacetUtils.getCollectionFacetFromSpec(collection);
        return facet.size(collection) == 0;
    }

    @Override
    public void addElement(NakedObject ownerAdapter, NakedObject referencedAdapter) {
        if (referencedAdapter == null) {
            throw new IllegalArgumentException("Can't use null to add an item to a collection");
        }
        if (this.readWrite()) {
            if (ownerAdapter.isPersistent() && referencedAdapter.isTransient()) {
                throw new NakedObjectException("can't set a reference to a transient object from a persistent one: " + ownerAdapter.titleString() + " (persistent) -> " + referencedAdapter.titleString() + " (transient)");
            }
            CollectionAddToFacet facet = this.getFacet(CollectionAddToFacet.class);
            facet.add(ownerAdapter, referencedAdapter);
        }
    }

    @Override
    public void removeElement(NakedObject ownerAdapter, NakedObject referencedAdapter) {
        if (referencedAdapter == null) {
            throw new IllegalArgumentException("element should not be null");
        }
        if (this.readWrite()) {
            CollectionRemoveFromFacet facet = this.getFacet(CollectionRemoveFromFacet.class);
            facet.remove(ownerAdapter, referencedAdapter);
        }
    }

    public void removeAllAssociations(NakedObject ownerAdapter) {
        CollectionClearFacet facet = this.getFacet(CollectionClearFacet.class);
        facet.clear(ownerAdapter);
    }

    @Override
    public void clearCollection(NakedObject ownerAdapter) {
        if (this.readWrite()) {
            CollectionClearFacet facet = this.getFacet(CollectionClearFacet.class);
            facet.clear(ownerAdapter);
        }
    }

    @Override
    public NakedObject getDefault(NakedObject ownerAdapter) {
        return null;
    }

    @Override
    public void toDefault(NakedObject ownerAdapter) {
    }

    @Override
    public NakedObject[] getChoices(NakedObject ownerAdapter) {
        return new NakedObject[0];
    }

    @Override
    public boolean isOptionEnabled() {
        return false;
    }

    @Override
    public Instance getInstance(NakedObject nakedObject) {
        OneToManyAssociationImpl specification = this;
        return nakedObject.getInstance(specification);
    }

    @Override
    public String debugData() {
        DebugString debugString = new DebugString();
        debugString.indent();
        debugString.indent();
        this.reflectiveAdapter.debugData(debugString);
        return debugString.toString();
    }

    @Override
    public String toString() {
        ToString str = new ToString(this);
        str.append(super.toString());
        str.append(",");
        str.append("persisted", this.isPersisted());
        str.append("type", this.getSpecification() == null ? "unknown" : this.getSpecification().getShortName());
        return str.toString();
    }
}

