/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.BooleanValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.util.NakedObjectUtils;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BooleanValueSemanticsProviderAbstract
extends ValueSemanticsProviderAbstract
implements BooleanValueFacet {
    private static final int TYPICAL_LENGTH = 5;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;

    private static Class<? extends Facet> type() {
        return BooleanValueFacet.class;
    }

    public BooleanValueSemanticsProviderAbstract(FacetHolder holder, Class<?> adaptedClass, Object defaultValue, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(BooleanValueSemanticsProviderAbstract.type(), holder, adaptedClass, 5, true, true, defaultValue, configuration, specificationLoader, runtimeContext);
    }

    @Override
    protected Object doParse(Object original, String entry) {
        if ("true".startsWith(entry.toLowerCase())) {
            return Boolean.TRUE;
        }
        if ("false".startsWith(entry.toLowerCase())) {
            return Boolean.FALSE;
        }
        throw new TextEntryParseException("Not a logical value " + entry);
    }

    @Override
    public String titleString(Object value) {
        return value == null ? "" : (this.isSet(value) ? "True" : "False");
    }

    @Override
    protected String doEncode(Object object) {
        return this.isSet(object) ? "T" : "F";
    }

    @Override
    protected Object doRestore(String data) {
        if (data.length() != 1) {
            throw new NakedObjectException("Invalid data for logical, expected 1 byte, got " + data.length());
        }
        switch (data.charAt(0)) {
            case 'T': {
                return Boolean.TRUE;
            }
            case 'F': {
                return Boolean.FALSE;
            }
        }
        throw new NakedObjectException("Invalid data for logical, expected 'T', 'F' or 'N, but got " + data.charAt(0));
    }

    private boolean isSet(Object value) {
        return (Boolean)value;
    }

    @Override
    public boolean isSet(NakedObject nakedObject) {
        if (!NakedObjectUtils.exists(nakedObject)) {
            return false;
        }
        Object object = nakedObject.getObject();
        Boolean objectAsBoolean = (Boolean)object;
        return objectAsBoolean;
    }
}

