/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.ByteValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ByteValueSemanticsProviderAbstract
extends ValueSemanticsProviderAbstract
implements ByteValueFacet {
    private static final int TYPICAL_LENGTH = 4;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private final NumberFormat format = this.determineNumberFormat("value.format.byte");

    private static Class<? extends Facet> type() {
        return ByteValueFacet.class;
    }

    public ByteValueSemanticsProviderAbstract(FacetHolder holder, Class<?> adaptedClass, Object defaultValue, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(ByteValueSemanticsProviderAbstract.type(), holder, adaptedClass, 4, true, true, defaultValue, configuration, specificationLoader, runtimeContext);
    }

    @Override
    protected Object doParse(Object original, String entry) {
        try {
            return new Byte(this.format.parse(entry).byteValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not a number " + entry, e);
        }
    }

    @Override
    public String titleString(Object value) {
        return this.titleString(this.format, value);
    }

    @Override
    public String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Object doRestore(String data) {
        return new Byte(data);
    }

    @Override
    public Byte byteValue(NakedObject object) {
        return (Byte)object.getObject();
    }

    @Override
    public NakedObject createValue(Byte value) {
        return this.getRuntimeContext().adapterFor(value);
    }

    @Override
    public String toString() {
        return "ByteAdapter: " + this.format;
    }
}

