/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.IntegerValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IntValueSemanticsProviderAbstract
extends ValueSemanticsProviderAbstract
implements IntegerValueFacet {
    private static final int TYPICAL_LENGTH = 9;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private final NumberFormat format = this.determineNumberFormat("value.format.int");

    public static Class<? extends Facet> type() {
        return IntegerValueFacet.class;
    }

    public IntValueSemanticsProviderAbstract(FacetHolder holder, Class<?> adaptedClass, Object defaultValue, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(IntValueSemanticsProviderAbstract.type(), holder, adaptedClass, 9, true, true, defaultValue, configuration, specificationLoader, runtimeContext);
    }

    @Override
    protected Object doParse(Object original, String entry) {
        try {
            return new Integer(this.format.parse(entry).intValue());
        }
        catch (ParseException e) {
            throw new TextEntryParseException("Not an whole number " + entry, e);
        }
    }

    @Override
    public String titleString(Object value) {
        return this.titleString(this.format, value);
    }

    public String titleWithMask(String mask, Object value) {
        return this.titleString(new DecimalFormat(mask), value);
    }

    @Override
    protected String doEncode(Object object) {
        return object.toString();
    }

    @Override
    protected Object doRestore(String data) {
        return new Integer(data);
    }

    @Override
    public Integer integerValue(NakedObject object) {
        return (Integer)(object == null ? null : object.getObject());
    }

    @Override
    public NakedObject createValue(Integer value) {
        return value == null ? null : this.getRuntimeContext().adapterFor(value);
    }

    @Override
    public String toString() {
        return "IntAdapter: " + this.format;
    }
}

