/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.applib.value.Money;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.commons.exceptions.NakedObjectException;
import org.nakedobjects.metamodel.commons.lang.ToString;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.properties.defaults.PropertyDefaultFacet;
import org.nakedobjects.metamodel.facets.value.MoneyValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoneyValueSemanticsProvider
extends ValueSemanticsProviderAbstract
implements MoneyValueFacet {
    private static final Object DEFAULT_VALUE = null;
    private static final NumberFormat DEFAULT_NUMBER_FORMAT = NumberFormat.getNumberInstance();
    private static final NumberFormat DEFAULT_CURRENCY_FORMAT = NumberFormat.getCurrencyInstance();
    private static final String LOCAL_CURRENCY_CODE;
    private static final int TYPICAL_LENGTH = 18;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private String defaultCurrencyCode;

    private static Class<? extends Facet> type() {
        return MoneyValueFacet.class;
    }

    static final boolean isAPropertyDefaultFacet() {
        return PropertyDefaultFacet.class.isAssignableFrom(MoneyValueSemanticsProvider.class);
    }

    private static String getDefaultCurrencyCode() {
        try {
            Class<?> type = DEFAULT_CURRENCY_FORMAT.getClass();
            try {
                Object currency = type.getMethod("getCurrency", null).invoke((Object)DEFAULT_CURRENCY_FORMAT, (Object[])null);
                return (String)currency.getClass().getMethod("getCurrencyCode", null).invoke(currency, (Object[])null);
            }
            catch (NoSuchMethodException nsm) {
                return "";
            }
        }
        catch (Exception e) {
            throw new NakedObjectException(e);
        }
    }

    public MoneyValueSemanticsProvider() {
        this(null, null, null, null);
    }

    public MoneyValueSemanticsProvider(FacetHolder holder, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(MoneyValueSemanticsProvider.type(), holder, Money.class, 18, true, true, DEFAULT_VALUE, configuration, specificationLoader, runtimeContext);
        String property = "nakedobjects.value.money.currency";
        this.defaultCurrencyCode = configuration.getString("nakedobjects.value.money.currency", LOCAL_CURRENCY_CODE);
    }

    @Override
    protected Object doParse(Object original, String text) {
        String entry = text.trim();
        int pos = entry.lastIndexOf(32);
        if (pos > 1) {
            return this.parseNumberAndCurrency(entry, pos);
        }
        return this.parseDerivedValue(original, entry);
    }

    private Object parseDerivedValue(Object original, String entry) {
        Money money;
        block5: {
            money = (Money)original;
            if (money == null || money.getCurrency().equals(LOCAL_CURRENCY_CODE)) {
                try {
                    double value = DEFAULT_CURRENCY_FORMAT.parse(entry).doubleValue();
                    money = new Money(value, LOCAL_CURRENCY_CODE);
                    return money;
                }
                catch (ParseException e) {
                    if (money != null) break block5;
                    throw new TextEntryParseException("Not a distinguishable money value " + entry, e);
                }
            }
        }
        try {
            double value = DEFAULT_NUMBER_FORMAT.parse(entry).doubleValue();
            String currencyCode = money == null ? this.defaultCurrencyCode : money.getCurrency();
            money = new Money(value, currencyCode);
            return money;
        }
        catch (ParseException ex) {
            throw new TextEntryParseException("Not a distinguishable money value " + entry, ex);
        }
    }

    private Object parseNumberAndCurrency(String entry, int pos) {
        String suffix = entry.substring(pos + 1).toLowerCase();
        if (suffix.length() == 3 && Character.isLowerCase(suffix.charAt(0)) && Character.isLowerCase(suffix.charAt(1)) && Character.isLowerCase(suffix.charAt(2))) {
            String currencyCode = suffix;
            String amount = entry.substring(0, entry.lastIndexOf(32));
            try {
                Money money = new Money(DEFAULT_NUMBER_FORMAT.parse(amount).doubleValue(), currencyCode);
                return money;
            }
            catch (ParseException e) {
                throw new TextEntryParseException("Invalid money entry", e);
            }
        }
        throw new TextEntryParseException("Not a distinguishable money value " + entry);
    }

    @Override
    public String titleString(Object object) {
        if (object == null) {
            return "";
        }
        Money money = (Money)object;
        boolean localCurrency = LOCAL_CURRENCY_CODE.equals(money.getCurrency());
        if (localCurrency) {
            return DEFAULT_CURRENCY_FORMAT.format(money.doubleValue());
        }
        return DEFAULT_NUMBER_FORMAT.format(money.doubleValue()) + " " + money.getCurrency();
    }

    public String titleStringWithMask(String mask, Object value) {
        if (value == null) {
            return "";
        }
        Money money = (Money)value;
        return new DecimalFormat(mask).format(money.doubleValue());
    }

    @Override
    protected String doEncode(Object object) {
        Money money = (Money)object;
        String value = String.valueOf(money.doubleValue()) + " " + money.getCurrency();
        return value;
    }

    @Override
    protected Object doRestore(String data) {
        String dataString = new String(data);
        int pos = dataString.indexOf(32);
        String amount = dataString.substring(0, pos);
        String currency = dataString.substring(pos + 1);
        return new Money(Double.valueOf(amount).doubleValue(), currency);
    }

    @Override
    public float getAmount(NakedObject object) {
        Money money = (Money)object.getObject();
        if (money == null) {
            return 0.0f;
        }
        return money.floatValue();
    }

    @Override
    public String getCurrencyCode(NakedObject object) {
        Money money = (Money)object.getObject();
        if (money == null) {
            return "";
        }
        return money.getCurrency();
    }

    @Override
    public NakedObject createValue(float amount, String currencyCode) {
        return this.getRuntimeContext().adapterFor(new Money((double)amount, currencyCode));
    }

    @Override
    public String toString() {
        ToString toString = new ToString(this);
        toString.append("local currency", MoneyValueSemanticsProvider.getDefaultCurrencyCode());
        return toString.toString();
    }

    static {
        DEFAULT_NUMBER_FORMAT.setMinimumFractionDigits(DEFAULT_CURRENCY_FORMAT.getMinimumFractionDigits());
        DEFAULT_NUMBER_FORMAT.setMaximumFractionDigits(DEFAULT_CURRENCY_FORMAT.getMaximumFractionDigits());
        LOCAL_CURRENCY_CODE = MoneyValueSemanticsProvider.getDefaultCurrencyCode();
    }
}

