/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.nakedobjects.applib.value.MultilineString;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.MultilineStringValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultilineStringValueSemanticsProvider
extends ValueSemanticsProviderAbstract
implements MultilineStringValueFacet {
    private static final int TYPICAL_LENGTH = 200;
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private static final Object DEFAULT_VALUE = null;

    public static Class<? extends Facet> type() {
        return MultilineStringValueFacet.class;
    }

    public MultilineStringValueSemanticsProvider() {
        this(null, null, null, null);
    }

    public MultilineStringValueSemanticsProvider(FacetHolder holder, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(MultilineStringValueSemanticsProvider.type(), holder, MultilineString.class, 200, true, true, DEFAULT_VALUE, configuration, specificationLoader, runtimeContext);
    }

    @Override
    protected Object doParse(Object original, String text) {
        return new MultilineString(text);
    }

    @Override
    public String titleString(Object value) {
        return value == null ? "" : this.stringValue(value);
    }

    @Override
    protected String doEncode(Object object) {
        String text = this.stringValue(object);
        if (text.equals("NULL") || this.isEscaped(text)) {
            return this.escapeText(text);
        }
        return text;
    }

    @Override
    protected Object doRestore(String data) {
        if (this.isEscaped(data)) {
            return new MultilineString(data.substring(1));
        }
        return new MultilineString(data);
    }

    private boolean isEscaped(String text) {
        return text.startsWith("/");
    }

    private String escapeText(String text) {
        return "/" + text;
    }

    @Override
    public NakedObject createValue(String value) {
        return this.getRuntimeContext().adapterFor(new MultilineString(value));
    }

    @Override
    public String stringValue(NakedObject object) {
        return object == null ? null : this.stringValue(object.getObject());
    }

    private String stringValue(Object object) {
        return ((MultilineString)object).getString();
    }
}

