/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import org.nakedobjects.applib.value.Percentage;
import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.value.FloatingPointValueFacet;
import org.nakedobjects.metamodel.runtimecontext.RuntimeContext;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PercentageValueSemanticsProvider
extends ValueSemanticsProviderAbstract
implements FloatingPointValueFacet {
    private static final NumberFormat PERCENTAGE_FORMAT = NumberFormat.getPercentInstance();
    private static final NumberFormat DECIMAL_FORMAT = NumberFormat.getNumberInstance();
    private static final boolean IMMUTABLE = true;
    private static final boolean EQUAL_BY_CONTENT = true;
    private static final Object DEFAULT_VALUE = new Percentage(0.0f);
    private NumberFormat format = PERCENTAGE_FORMAT;

    public static Class<? extends Facet> type() {
        return FloatingPointValueFacet.class;
    }

    public PercentageValueSemanticsProvider() {
        this(null, null, null, null);
    }

    public PercentageValueSemanticsProvider(FacetHolder holder, NakedObjectConfiguration configuration, SpecificationLoader specificationLoader, RuntimeContext runtimeContext) {
        super(PercentageValueSemanticsProvider.type(), holder, Percentage.class, 12, true, true, DEFAULT_VALUE, configuration, specificationLoader, runtimeContext);
        String formatRequired = configuration.getString("nakedobjects.value.format.percentage");
        this.format = formatRequired == null ? PERCENTAGE_FORMAT : new DecimalFormat(formatRequired);
    }

    @Override
    protected Object doParse(Object original, String text) {
        try {
            return new Percentage(new Float(this.format.parse(text).floatValue()).floatValue());
        }
        catch (ParseException e) {
            try {
                return new Percentage(new Float(DECIMAL_FORMAT.parse(text).floatValue()).floatValue());
            }
            catch (ParseException ee) {
                throw new TextEntryParseException("Not a number " + text, ee);
            }
        }
    }

    @Override
    public String titleString(Object value) {
        return this.titleString(this.format, value);
    }

    private String titleString(NumberFormat formatter, Object value) {
        return value == null ? "" : this.format.format(((Percentage)value).floatValue());
    }

    public String titleStringWithMask(String mask, Object value) {
        return this.titleString(new DecimalFormat(mask), value);
    }

    @Override
    protected String doEncode(Object object) {
        Percentage per = (Percentage)object;
        return String.valueOf(per.floatValue());
    }

    @Override
    protected Object doRestore(String data) {
        return new Percentage(Float.valueOf(data).floatValue());
    }

    @Override
    public Float floatValue(NakedObject object) {
        Percentage per = (Percentage)object.getObject();
        return new Float(per.floatValue());
    }

    @Override
    public NakedObject createValue(Float value) {
        return this.getRuntimeContext().adapterFor(value);
    }

    public Object getDefault(NakedObject inObject) {
        return Float.valueOf(0.0f);
    }

    @Override
    public String toString() {
        return "PercentageValueSemanticsProvider: " + this.format;
    }
}

