package org.nakedobjects.metamodel.adapter.version;

import java.util.Date;



public abstract class VersionAbstract implements Version {
    protected String user;
    protected Date time;

    public VersionAbstract(final String user, final Date time) {
        this.user = user;
        this.time = time;
    }

    public Date getTime() {
        return time;
    }

    public String getUser() {
        return user;
    }

    public Version next(final String user, final Date time) {
        final VersionAbstract newVersion = next();
        newVersion.user = user;
        newVersion.time = time;
        return newVersion;
    }

    protected abstract VersionAbstract next();

}
// Copyright (c) Naked Objects Group Ltd.
