package org.nakedobjects.metamodel.authentication;

import org.nakedobjects.metamodel.commons.component.SessionScopedComponent;

/**
 * The representation within the system of an authenticated user.
 */
public interface AuthenticationSession extends SessionScopedComponent {
    /**
     * The name of the authenticated user; for display purposes only.
     */
    public String getUserName();

    /**
     * The roles this user belongs to
     */
    public String[] getRoles();

    /**
     * A unique code given to this session during authentication.
     * 
     * <p>
     * This can be used to confirm that this session has been properly created and the user has been
     * authenticated. It should return an empty string (<tt>""</tt>) if this is unauthenticated user (i.e., as
     * created within an exploration system).
     */
    public String getValidationCode();
}
// Copyright (c) Naked Objects Group Ltd.
