package org.nakedobjects.metamodel.authentication;

import org.nakedobjects.applib.security.RoleMemento;
import org.nakedobjects.applib.security.UserMemento;


public final class AuthenticationSessionUtils {

    private AuthenticationSessionUtils() {}

    public static UserMemento createUserMemento(final AuthenticationSession session) {
        final RoleMemento[] roles = new RoleMemento[session.getRoles().length];
        for (int i = 0; i < roles.length; i++) {
            roles[i] = new RoleMemento(session.getRoles()[i]);
        }
        return new UserMemento(session.getUserName(), roles);
    }
}

// Copyright (c) Naked Objects Group Ltd.
