package org.nakedobjects.metamodel.facets.actions.validate;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;

import org.nakedobjects.metamodel.adapter.NakedObject;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.java5.ImperativeFacet;
import org.nakedobjects.metamodel.util.NakedObjectInvokeUtils;


public class ActionValidationFacetViaMethod extends ActionValidationFacetAbstract implements ImperativeFacet {

    private final Method method;

    public ActionValidationFacetViaMethod(
    		final Method method, 
    		final FacetHolder holder) {
        super(holder);
        this.method = method;
    }

    /**
     * Returns a singleton list of the {@link Method} provided in the constructor. 
     */
    public List<Method> getMethods() {
    	return Collections.singletonList(method);
    }

    public String invalidReason(final NakedObject owningAdapter, final NakedObject[] proposedArgumentAdapters) {
        return (String) NakedObjectInvokeUtils.invoke(method, owningAdapter, proposedArgumentAdapters);
    }

    @Override
    protected String toStringValues() {
        return "method=" + method;
    }

}

// Copyright (c) Naked Objects Group Ltd.
