/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.actions;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.nakedobjects.applib.Identifier;
import org.nakedobjects.applib.annotation.Named;
import org.nakedobjects.applib.security.UserMemento;
import org.nakedobjects.metamodel.exceptions.ReflectionException;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.When;
import org.nakedobjects.metamodel.facets.actions.ActionMethodsFacetFactory;
import org.nakedobjects.metamodel.facets.actions.choices.ActionChoicesFacet;
import org.nakedobjects.metamodel.facets.actions.choices.ActionChoicesFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.choices.ActionParameterChoicesFacet;
import org.nakedobjects.metamodel.facets.actions.choices.ActionParameterChoicesFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.debug.DebugFacet;
import org.nakedobjects.metamodel.facets.actions.defaults.ActionDefaultsFacet;
import org.nakedobjects.metamodel.facets.actions.defaults.ActionDefaultsFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.defaults.ActionParameterDefaultsFacet;
import org.nakedobjects.metamodel.facets.actions.defaults.ActionParameterDefaultsFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.executed.ExecutedFacet;
import org.nakedobjects.metamodel.facets.actions.exploration.ExplorationFacet;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacet;
import org.nakedobjects.metamodel.facets.actions.invoke.ActionInvocationFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.validate.ActionValidationFacet;
import org.nakedobjects.metamodel.facets.actions.validate.ActionValidationFacetViaMethod;
import org.nakedobjects.metamodel.facets.disable.DisableForSessionFacet;
import org.nakedobjects.metamodel.facets.disable.DisableForSessionFacetViaMethod;
import org.nakedobjects.metamodel.facets.disable.DisabledFacet;
import org.nakedobjects.metamodel.facets.disable.DisabledFacetAbstract;
import org.nakedobjects.metamodel.facets.hide.HiddenFacet;
import org.nakedobjects.metamodel.facets.hide.HiddenFacetAbstract;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacet;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacetViaMethod;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsFacet;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsFacetAbstract;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacet;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacetAbstract;
import org.nakedobjects.metamodel.spec.NakedObjectSpecification;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaNakedObjectActionParamPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.JavaNakedObjectActionPeer;
import org.nakedobjects.metamodel.specloader.internal.peer.NakedObjectActionPeer;
import org.nakedobjects.metamodel.testspec.TestProxySpecification;

public class ActionMethodsFacetFactoryTest
extends AbstractFacetFactoryTest {
    private ActionMethodsFacetFactory facetFactory;
    private final NakedObjectSpecification voidNoSpec = new TestProxySpecification("VOID");
    private final NakedObjectSpecification stringNoSpec = new TestProxySpecification("java.lang.String");
    private final NakedObjectSpecification customerNoSpec = new TestProxySpecification("Customer");

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new ActionMethodsFacetFactory();
        this.facetFactory.setSpecificationLoader((SpecificationLoader)this.reflector);
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        ActionMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        ActionMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        ActionMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        ActionMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testActionInvocationFacetIsInstalledAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ActionInvocationFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ActionInvocationFacetViaMethod));
        ActionInvocationFacetViaMethod actionInvocationFacetViaMethod = (ActionInvocationFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)actionMethod, actionInvocationFacetViaMethod.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(actionMethod));
    }

    public void testProvidesDefaultNameForActionButIgnoresAnyNamedAnnotation() {
        class Customer {
            Customer() {
            }

            @Named(value="Renamed an action with a named annotation")
            public void anActionWithNamedAnnotation() {
            }
        }
        Method method = this.findMethod(Customer.class, "anActionWithNamedAnnotation");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NamedFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacet));
        NamedFacet namedFacet = (NamedFacet)facet;
        ActionMethodsFacetFactoryTest.assertEquals((String)"An Action With Named Annotation", (String)namedFacet.value());
    }

    public void testPicksUpDebugPrefixAndSetsNameAppropriatelyAlso() {
        class Customer {
            Customer() {
            }

            public void debugAnActionWithDebugPrefix() {
            }
        }
        Method method = this.findMethod(Customer.class, "debugAnActionWithDebugPrefix");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DebugFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DebugFacet));
        facet = this.facetHolder.getFacet(NamedFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacet));
        NamedFacet namedFacet = (NamedFacet)facet;
        ActionMethodsFacetFactoryTest.assertEquals((String)"An Action With Debug Prefix", (String)namedFacet.value());
    }

    public void testPicksUpExplorationPrefixAndSetsNameAppropriatelyAlso() {
        class Customer {
            Customer() {
            }

            public void explorationAnActionWithExplorationPrefix() {
            }
        }
        Method method = this.findMethod(Customer.class, "explorationAnActionWithExplorationPrefix");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ExplorationFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ExplorationFacet));
        facet = this.facetHolder.getFacet(NamedFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacet));
        NamedFacet namedFacet = (NamedFacet)facet;
        ActionMethodsFacetFactoryTest.assertEquals((String)"An Action With Exploration Prefix", (String)namedFacet.value());
    }

    public void testCannotHaveBothDebugAndThenExplorationPrefix() {
        class Customer {
            Customer() {
            }

            public void debugExplorationAnActionWithDebugAndExplorationPrefix() {
            }
        }
        Method method = this.findMethod(Customer.class, "debugExplorationAnActionWithDebugAndExplorationPrefix");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DebugFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DebugFacet));
        facet = this.facetHolder.getFacet(ExplorationFacet.class);
        ActionMethodsFacetFactoryTest.assertNull((Object)facet);
    }

    public void testCannotHaveBothExplorationAndThenDebugPrefix() {
        class Customer {
            Customer() {
            }

            public void explorationDebugAnActionWithExplorationAndDebugPrefix() {
            }
        }
        Method method = this.findMethod(Customer.class, "explorationDebugAnActionWithExplorationAndDebugPrefix");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ExplorationFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ExplorationFacet));
        facet = this.facetHolder.getFacet(DebugFacet.class);
        ActionMethodsFacetFactoryTest.assertNull((Object)facet);
    }

    public void testPicksUpLocalPrefixAndSetsNameAppropriatelyAlso() {
        class Customer {
            Customer() {
            }

            public void localAnActionWithLocalPrefix() {
            }
        }
        Method method = this.findMethod(Customer.class, "localAnActionWithLocalPrefix");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ExecutedFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ExecutedFacet));
        ExecutedFacet executedFacet = (ExecutedFacet)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)ExecutedFacet.Where.LOCALLY, (Object)executedFacet.value());
        facet = this.facetHolder.getFacet(NamedFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacet));
        NamedFacet namedFacet = (NamedFacet)facet;
        ActionMethodsFacetFactoryTest.assertEquals((String)"An Action With Local Prefix", (String)namedFacet.value());
    }

    public void testPicksUpRemotePrefixAndSetsNameAppropriatelyAlso() {
        class Customer {
            Customer() {
            }

            public void remoteAnActionWithRemotePrefix() {
            }
        }
        Method method = this.findMethod(Customer.class, "remoteAnActionWithRemotePrefix");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(method, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ExecutedFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ExecutedFacet));
        ExecutedFacet executedFacet = (ExecutedFacet)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)ExecutedFacet.Where.REMOTELY, (Object)executedFacet.value());
        facet = this.facetHolder.getFacet(NamedFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacet));
        NamedFacet namedFacet = (NamedFacet)facet;
        ActionMethodsFacetFactoryTest.assertEquals((String)"An Action With Remote Prefix", (String)namedFacet.value());
    }

    public void testInstallsValidateMethodNoArgsFacetAndRemovesMethod() {
        class Customer {
            Customer() {
            }

            public void someAction() {
            }

            public String validateSomeAction() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        Method validateMethod = this.findMethod(Customer.class, "validateSomeAction");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ActionValidationFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ActionValidationFacetViaMethod));
        ActionValidationFacetViaMethod actionValidationFacetViaMethod = (ActionValidationFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)validateMethod, actionValidationFacetViaMethod.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(validateMethod));
    }

    public void testInstallsValidateMethodSomeArgsFacetAndRemovesMethod() {
        class Customer {
            Customer() {
            }

            public void someAction(int x, int y) {
            }

            public String validateSomeAction(int x, int y) {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE, Integer.TYPE});
        Method validateMethod = this.findMethod(Customer.class, "validateSomeAction", new Class[]{Integer.TYPE, Integer.TYPE});
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ActionValidationFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ActionValidationFacetViaMethod));
        ActionValidationFacetViaMethod actionValidationFacetViaMethod = (ActionValidationFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)validateMethod, actionValidationFacetViaMethod.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(validateMethod));
    }

    public void testInstallsParameterDefaultsMethodSomeArgsFacetAndRemovesMethod() {
        class Customer {
            Customer() {
            }

            public void someAction(int x, Long y) {
            }

            public Object[] defaultSomeAction(int x, Long y) {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE, Long.class});
        Method defaultMethod = this.findMethod(Customer.class, "defaultSomeAction", new Class[]{Integer.TYPE, Long.class});
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ActionDefaultsFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ActionDefaultsFacetViaMethod));
        ActionDefaultsFacetViaMethod actionDefaultFacetViaMethod = (ActionDefaultsFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)defaultMethod, actionDefaultFacetViaMethod.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(defaultMethod));
    }

    public void testInstallsParameterDefaultsMethodNoArgsFacetAndRemovesMethod() {
        class Customer {
            Customer() {
            }

            public void someAction(int x, Long y) {
            }

            public Object[] defaultSomeAction() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE, Long.class});
        Method defaultMethod = this.findMethod(Customer.class, "defaultSomeAction", new Class[0]);
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ActionDefaultsFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ActionDefaultsFacetViaMethod));
        ActionDefaultsFacetViaMethod actionDefaultFacetViaMethod = (ActionDefaultsFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)defaultMethod, actionDefaultFacetViaMethod.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(defaultMethod));
    }

    public void testInstallsParameterChoicesMethodSomeArgsFacetAndRemovesMethod() {
        class Customer {
            Customer() {
            }

            public void someAction(int x, Long y) {
            }

            public Object[] choicesSomeAction(int x, Long y) {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE, Long.class});
        Method choicesMethod = this.findMethod(Customer.class, "choicesSomeAction", new Class[]{Integer.TYPE, Long.class});
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ActionChoicesFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ActionChoicesFacetViaMethod));
        ActionChoicesFacetViaMethod actionChoicesFacetViaMethod = (ActionChoicesFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)choicesMethod, actionChoicesFacetViaMethod.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(choicesMethod));
    }

    public void testInstallsParameterChoicesMethodNoArgsFacetAndRemovesMethod() {
        class Customer {
            Customer() {
            }

            public void someAction(int x, Long y) {
            }

            public Object[] choicesSomeAction() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE, Long.class});
        Method choicesMethod = this.findMethod(Customer.class, "choicesSomeAction", new Class[0]);
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ActionChoicesFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof ActionChoicesFacetViaMethod));
        ActionChoicesFacetViaMethod actionChoicesFacetViaMethod = (ActionChoicesFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)choicesMethod, actionChoicesFacetViaMethod.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(choicesMethod));
    }

    public void testInstallsNamedFacetUsingNameMethodAndRemovesMethod() {
        Method actionMethod = this.findMethod(CustomerStatic.class, "someAction", new Class[]{Integer.TYPE, Long.class});
        Method nameMethod = this.findMethod(CustomerStatic.class, "nameSomeAction");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NamedFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacetAbstract));
        NamedFacetAbstract namedFacetAbstract = (NamedFacetAbstract)facet;
        ActionMethodsFacetFactoryTest.assertEquals((String)"Another Name", (String)namedFacetAbstract.value());
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(nameMethod));
    }

    public void testInstallsDescribedAsFacetUsingDescriptionAndRemovesMethod() {
        Method actionMethod = this.findMethod(CustomerStatic.class, "someAction", new Class[]{Integer.TYPE, Long.class});
        Method descriptionMethod = this.findMethod(CustomerStatic.class, "descriptionSomeAction");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DescribedAsFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DescribedAsFacetAbstract));
        DescribedAsFacetAbstract describedAsFacetAbstract = (DescribedAsFacetAbstract)facet;
        ActionMethodsFacetFactoryTest.assertEquals((String)"Some old description", (String)describedAsFacetAbstract.value());
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(descriptionMethod));
    }

    public void testInstallsHiddenFacetUsingAlwaysHideAndRemovesMethod() {
        Method actionMethod = this.findMethod(CustomerStatic.class, "someAction", new Class[]{Integer.TYPE, Long.class});
        Method alwaysHideMethod = this.findMethod(CustomerStatic.class, "alwaysHideSomeAction", new Class[]{Integer.TYPE, Long.class});
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HiddenFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof HiddenFacetAbstract));
        HiddenFacetAbstract hiddenFacetAbstract = (HiddenFacetAbstract)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)When.ALWAYS, (Object)hiddenFacetAbstract.value());
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(alwaysHideMethod));
    }

    public void testInstallsHiddenFacetUsingAlwaysHideWhenNotAndRemovesMethod() {
        Method actionMethod = this.findMethod(CustomerStatic.class, "otherAction", new Class[]{Integer.TYPE, Long.class});
        Method alwaysHideMethod = this.findMethod(CustomerStatic.class, "alwaysHideOtherAction", new Class[]{Integer.TYPE, Long.class});
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ActionMethodsFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(HiddenFacet.class));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(alwaysHideMethod));
    }

    public void testInstallsDisabledFacetUsingProtectAndRemovesMethod() {
        Method actionMethod = this.findMethod(CustomerStatic.class, "someAction", new Class[]{Integer.TYPE, Long.class});
        Method protectMethod = this.findMethod(CustomerStatic.class, "protectSomeAction", new Class[]{Integer.TYPE, Long.class});
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisabledFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DisabledFacetAbstract));
        DisabledFacetAbstract disabledFacetAbstract = (DisabledFacetAbstract)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)When.ALWAYS, (Object)disabledFacetAbstract.value());
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(protectMethod));
    }

    public void testDoesNotInstallDisabledFacetUsingProtectWhenNotAndRemovesMethod() {
        Method actionMethod = this.findMethod(CustomerStatic.class, "otherAction", new Class[]{Integer.TYPE, Long.class});
        Method protectMethod = this.findMethod(CustomerStatic.class, "protectOtherAction", new Class[]{Integer.TYPE, Long.class});
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        ActionMethodsFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(DisabledFacet.class));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(protectMethod));
    }

    public void testInstallsHiddenForSessionFacetAndRemovesMethod() {
        Method actionMethod = this.findMethod(CustomerStatic.class, "someAction", new Class[]{Integer.TYPE, Long.class});
        Method hideMethod = this.findMethod(CustomerStatic.class, "hideSomeAction", new Class[]{UserMemento.class});
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HideForSessionFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof HideForSessionFacetViaMethod));
        HideForSessionFacetViaMethod hideForSessionFacetViaMethod = (HideForSessionFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)hideMethod, hideForSessionFacetViaMethod.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(hideMethod));
    }

    public void testInstallsDisabledForSessionFacetAndRemovesMethod() {
        Method actionMethod = this.findMethod(CustomerStatic.class, "someAction", new Class[]{Integer.TYPE, Long.class});
        Method disableMethod = this.findMethod(CustomerStatic.class, "disableSomeAction", new Class[]{UserMemento.class});
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisableForSessionFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DisableForSessionFacetViaMethod));
        DisableForSessionFacetViaMethod disableForSessionFacetViaMethod = (DisableForSessionFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)disableMethod, disableForSessionFacetViaMethod.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(disableMethod));
    }

    public void testActionReturnTypeWhenVoid() {
        class Customer {
            Customer() {
            }

            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ActionInvocationFacet.class);
        ActionInvocationFacetViaMethod actionInvocationFacetViaMethod = (ActionInvocationFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)this.voidNoSpec, (Object)actionInvocationFacetViaMethod.getReturnType());
    }

    public void testActionReturnTypeWhenNotVoid() {
        class Customer {
            Customer() {
            }

            public String someAction() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.reflector.setLoadSpecificationStringReturn(this.stringNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ActionInvocationFacet.class);
        ActionInvocationFacetViaMethod actionInvocationFacetViaMethod = (ActionInvocationFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)this.stringNoSpec, (Object)actionInvocationFacetViaMethod.getReturnType());
    }

    public void testActionOnType() {
        class Customer {
            Customer() {
            }

            public String someAction() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.reflector.setLoadSpecificationStringReturn(this.customerNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ActionInvocationFacet.class);
        ActionInvocationFacetViaMethod actionInvocationFacetViaMethod = (ActionInvocationFacetViaMethod)facet;
        ActionMethodsFacetFactoryTest.assertEquals((Object)this.customerNoSpec, (Object)actionInvocationFacetViaMethod.getOnType());
    }

    private static NakedObjectActionPeer createHolderWithParms() {
        JavaNakedObjectActionParamPeer param1 = new JavaNakedObjectActionParamPeer((NakedObjectSpecification)new TestProxySpecification("java.lang.Integer"));
        JavaNakedObjectActionParamPeer param2 = new JavaNakedObjectActionParamPeer((NakedObjectSpecification)new TestProxySpecification("java.lang.Long"));
        JavaNakedObjectActionParamPeer[] parms = new JavaNakedObjectActionParamPeer[]{param1, param2};
        Identifier id = Identifier.classIdentifier((String)"action");
        return new JavaNakedObjectActionPeer(id, parms);
    }

    public void testInstallsParameterDefaultsMethodAndRemovesMethod() {
        class Customer {
            Customer() {
            }

            public void someAction(int x, long y) {
            }

            public int default0SomeAction() {
                return 0;
            }

            public long default1SomeAction() {
                return 0L;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE, Long.TYPE});
        Method default0Method = this.findMethod(Customer.class, "default0SomeAction", new Class[0]);
        Method default1Method = this.findMethod(Customer.class, "default1SomeAction", new Class[0]);
        NakedObjectActionPeer facetHolderWithParms = ActionMethodsFacetFactoryTest.createHolderWithParms();
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)facetHolderWithParms);
        Facet facet0 = facetHolderWithParms.getParameters()[0].getFacet(ActionParameterDefaultsFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet0);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet0 instanceof ActionParameterDefaultsFacetViaMethod));
        ActionParameterDefaultsFacetViaMethod actionDefaultFacetViaMethod0 = (ActionParameterDefaultsFacetViaMethod)facet0;
        ActionMethodsFacetFactoryTest.assertEquals((Object)default0Method, actionDefaultFacetViaMethod0.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(default0Method));
        Facet facet1 = facetHolderWithParms.getParameters()[1].getFacet(ActionParameterDefaultsFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet1);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet1 instanceof ActionParameterDefaultsFacetViaMethod));
        ActionParameterDefaultsFacetViaMethod actionDefaultFacetViaMethod1 = (ActionParameterDefaultsFacetViaMethod)facet1;
        ActionMethodsFacetFactoryTest.assertEquals((Object)default1Method, actionDefaultFacetViaMethod1.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(default1Method));
    }

    public void testInstallsParameterChoicesMethodAndRemovesMethod() {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Customer {
            Customer() {
            }

            public void someAction(int x, long y) {
            }

            public List<Integer> choices0SomeAction() {
                return Collections.emptyList();
            }

            public List<Long> choices1SomeAction() {
                return Collections.emptyList();
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE, Long.TYPE});
        Method choices0Method = this.findMethod(Customer.class, "choices0SomeAction", new Class[0]);
        Method choices1Method = this.findMethod(Customer.class, "choices1SomeAction", new Class[0]);
        NakedObjectActionPeer facetHolderWithParms = ActionMethodsFacetFactoryTest.createHolderWithParms();
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)facetHolderWithParms);
        Facet facet0 = facetHolderWithParms.getParameters()[0].getFacet(ActionParameterChoicesFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet0);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet0 instanceof ActionParameterChoicesFacetViaMethod));
        ActionParameterChoicesFacetViaMethod actionChoicesFacetViaMethod0 = (ActionParameterChoicesFacetViaMethod)facet0;
        ActionMethodsFacetFactoryTest.assertEquals((Object)choices0Method, actionChoicesFacetViaMethod0.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(choices0Method));
        Facet facet1 = facetHolderWithParms.getParameters()[1].getFacet(ActionParameterChoicesFacet.class);
        ActionMethodsFacetFactoryTest.assertNotNull((Object)facet1);
        ActionMethodsFacetFactoryTest.assertTrue((boolean)(facet1 instanceof ActionParameterChoicesFacetViaMethod));
        ActionParameterChoicesFacetViaMethod actionChoicesFacetViaMethod1 = (ActionParameterChoicesFacetViaMethod)facet1;
        ActionMethodsFacetFactoryTest.assertEquals((Object)choices1Method, actionChoicesFacetViaMethod1.getMethods().get(0));
        ActionMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(choices1Method));
    }

    public void testBothChoicesMethodCausesException() {
        class Customer {
            Customer() {
            }

            public void someAction(int x, long y) {
            }

            public int[] choices0SomeAction() {
                return new int[0];
            }

            public long[] choices1SomeAction() {
                return new long[0];
            }

            public Object[] choicesSomeAction(int x, long y) {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE, Long.TYPE});
        NakedObjectActionPeer facetHolderWithParms = ActionMethodsFacetFactoryTest.createHolderWithParms();
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        try {
            this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)facetHolderWithParms);
            ActionMethodsFacetFactoryTest.fail((String)"exception expected");
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void testBothDefaultMethodCausesException() {
        class Customer {
            Customer() {
            }

            public void someAction(int x, long y) {
            }

            public int default0SomeAction() {
                return 0;
            }

            public long default1SomeAction() {
                return 0L;
            }

            public Object[] defaultSomeAction(int x, long y) {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE, Long.TYPE});
        NakedObjectActionPeer facetHolderWithParms = ActionMethodsFacetFactoryTest.createHolderWithParms();
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        try {
            this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)facetHolderWithParms);
            ActionMethodsFacetFactoryTest.fail((String)"exception expected");
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void testBothDefaultChoicesMethodCausesException() {
        class Customer {
            Customer() {
            }

            public void someAction(int x, long y) {
            }

            public int default0SomeAction() {
                return 0;
            }

            public long default1SomeAction() {
                return 0L;
            }

            public Object[] choicesSomeAction(int x, long y) {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE, Long.TYPE});
        NakedObjectActionPeer facetHolderWithParms = ActionMethodsFacetFactoryTest.createHolderWithParms();
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        try {
            this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)facetHolderWithParms);
            ActionMethodsFacetFactoryTest.fail((String)"exception expected");
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public void testBothChoicesDefaultMethodCausesException() {
        class Customer {
            Customer() {
            }

            public void someAction(int x, long y) {
            }

            public int[] choices0SomeAction() {
                return new int[0];
            }

            public long[] choices1SomeAction() {
                return new long[0];
            }

            public Object[] defaultSomeAction(int x, long y) {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction", new Class[]{Integer.TYPE, Long.TYPE});
        NakedObjectActionPeer facetHolderWithParms = ActionMethodsFacetFactoryTest.createHolderWithParms();
        this.reflector.setLoadSpecificationStringReturn(this.voidNoSpec);
        try {
            this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)facetHolderWithParms);
            ActionMethodsFacetFactoryTest.fail((String)"exception expected");
        }
        catch (ReflectionException reflectionException) {
            // empty catch block
        }
    }

    public static class CustomerStatic {
        public void someAction(int x, Long y) {
        }

        public static String nameSomeAction() {
            return "Another Name";
        }

        public static String descriptionSomeAction() {
            return "Some old description";
        }

        public static boolean alwaysHideSomeAction(int x, Long y) {
            return true;
        }

        public static boolean protectSomeAction(int x, Long y) {
            return true;
        }

        public static boolean hideSomeAction(UserMemento userMemento) {
            return true;
        }

        public static String disableSomeAction(UserMemento userMemento) {
            return "disabled for this user";
        }

        public static void otherAction(int x, Long y) {
        }

        public static boolean alwaysHideOtherAction(int x, Long y) {
            return false;
        }

        public static boolean protectOtherAction(int x, Long y) {
            return false;
        }
    }
}

