/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.actions;

import java.lang.reflect.Method;
import java.util.Iterator;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.actions.IteratorFilteringFacetFactory;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class IteratorFilteringFacetFactoryTest
extends AbstractFacetFactoryTest {
    private IteratorFilteringFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new IteratorFilteringFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        IteratorFilteringFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        IteratorFilteringFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        IteratorFilteringFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        IteratorFilteringFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        IteratorFilteringFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testRequestsRemoverToRemoveIteratorMethods() {
        class Customer {
            Customer() {
            }

            public void someAction() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        IteratorFilteringFacetFactoryTest.assertEquals((int)1, (int)this.methodRemover.getRemoveMethodArgsCalls().size());
    }

    public void testNoIteratorMethodFiltered() {
        class Customer {
            Customer() {
            }

            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        IteratorFilteringFacetFactoryTest.assertFalse((boolean)this.facetFactory.recognizes(actionMethod));
    }

    public void xxxtestIterableIteratorMethodFiltered() {
        class Customer
        implements Iterable {
            Customer() {
            }

            public void someAction() {
            }

            public Iterator iterator() {
                return null;
            }
        }
        Method iteratorMethod = this.findMethod(Customer.class, "iterator");
        IteratorFilteringFacetFactoryTest.assertTrue((boolean)this.facetFactory.recognizes(iteratorMethod));
    }
}

