/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.actions.debug;

import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.Debug;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.actions.debug.DebugAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.actions.debug.DebugFacet;
import org.nakedobjects.metamodel.facets.actions.debug.DebugFacetAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class DebugAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private DebugAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new DebugAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        DebugAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        DebugAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        DebugAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        DebugAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        DebugAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testDebugAnnotationPickedUp() {
        class Customer {
            Customer() {
            }

            @Debug
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DebugFacet.class);
        DebugAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        DebugAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof DebugFacetAbstract));
        this.assertNoMethodsRemoved();
    }
}

