/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.actions.exploration;

import java.lang.reflect.Method;
import org.nakedobjects.applib.annotation.Exploration;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.actions.exploration.ExplorationAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.actions.exploration.ExplorationFacet;
import org.nakedobjects.metamodel.facets.actions.exploration.ExplorationFacetAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class ExplorationAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private ExplorationAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new ExplorationAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        ExplorationAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        ExplorationAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        ExplorationAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        ExplorationAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        ExplorationAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testExplorationAnnotationPickedUp() {
        class Customer {
            Customer() {
            }

            @Exploration
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(ExplorationFacet.class);
        ExplorationAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        ExplorationAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof ExplorationFacetAbstract));
        ExplorationFacetAbstract executedFacetImpl = (ExplorationFacetAbstract)facet;
        this.assertNoMethodsRemoved();
    }
}

