/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.collections;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.nakedobjects.applib.security.UserMemento;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.When;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacet;
import org.nakedobjects.metamodel.facets.actcoll.typeof.TypeOfFacetInferredFromSupportingMethods;
import org.nakedobjects.metamodel.facets.actions.DescribedAsFacetViaMethod;
import org.nakedobjects.metamodel.facets.actions.NamedFacetViaMethod;
import org.nakedobjects.metamodel.facets.collections.CollectionFieldMethodsFacetFactory;
import org.nakedobjects.metamodel.facets.collections.CollectionFieldMethodsFacetFactoryTest;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacetViaAccessor;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionAddToFacetViaMethod;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionClearFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionClearFacetViaAccessor;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionClearFacetViaMethod;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacet;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacetViaAccessor;
import org.nakedobjects.metamodel.facets.collections.modify.CollectionRemoveFromFacetViaMethod;
import org.nakedobjects.metamodel.facets.collections.validate.CollectionValidateAddToFacet;
import org.nakedobjects.metamodel.facets.collections.validate.CollectionValidateAddToFacetViaMethod;
import org.nakedobjects.metamodel.facets.collections.validate.CollectionValidateRemoveFromFacet;
import org.nakedobjects.metamodel.facets.collections.validate.CollectionValidateRemoveFromFacetViaMethod;
import org.nakedobjects.metamodel.facets.disable.DisableForSessionFacet;
import org.nakedobjects.metamodel.facets.disable.DisableForSessionFacetViaMethod;
import org.nakedobjects.metamodel.facets.disable.DisabledFacet;
import org.nakedobjects.metamodel.facets.disable.DisabledFacetAlways;
import org.nakedobjects.metamodel.facets.hide.HiddenFacet;
import org.nakedobjects.metamodel.facets.hide.HiddenFacetAlways;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacet;
import org.nakedobjects.metamodel.facets.hide.HideForSessionFacetViaMethod;
import org.nakedobjects.metamodel.facets.naming.describedas.DescribedAsFacet;
import org.nakedobjects.metamodel.facets.naming.named.NamedFacet;
import org.nakedobjects.metamodel.facets.propcoll.access.PropertyAccessorFacet;
import org.nakedobjects.metamodel.facets.propcoll.access.PropertyAccessorFacetViaAccessor;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;
import org.nakedobjects.metamodel.specloader.SpecificationLoader;

public class CollectionFieldMethodsFacetFactoryTest
extends AbstractFacetFactoryTest {
    private CollectionFieldMethodsFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new CollectionFieldMethodsFacetFactory();
        this.facetFactory.setSpecificationLoader((SpecificationLoader)this.reflector);
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        CollectionFieldMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        CollectionFieldMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        CollectionFieldMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        CollectionFieldMethodsFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testPropertyAccessorFacetIsInstalledForJavaUtilCollectionAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyAccessorFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyAccessorFacetViaAccessor));
        PropertyAccessorFacetViaAccessor propertyAccessorFacetViaAccessor = (PropertyAccessorFacetViaAccessor)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)collectionAccessorMethod, propertyAccessorFacetViaAccessor.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(collectionAccessorMethod));
    }

    public void testPropertyAccessorFacetIsInstalledForJavaUtilListAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public List getOrders() {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyAccessorFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyAccessorFacetViaAccessor));
        PropertyAccessorFacetViaAccessor propertyAccessorFacetViaAccessor = (PropertyAccessorFacetViaAccessor)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)collectionAccessorMethod, propertyAccessorFacetViaAccessor.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(collectionAccessorMethod));
    }

    public void testPropertyAccessorFacetIsInstalledForJavaUtilSetAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public Set getOrders() {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyAccessorFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyAccessorFacetViaAccessor));
        PropertyAccessorFacetViaAccessor propertyAccessorFacetViaAccessor = (PropertyAccessorFacetViaAccessor)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)collectionAccessorMethod, propertyAccessorFacetViaAccessor.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(collectionAccessorMethod));
    }

    public void testPropertyAccessorFacetIsInstalledForObjectArrayAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public Object[] getOrders() {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyAccessorFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyAccessorFacetViaAccessor));
        PropertyAccessorFacetViaAccessor propertyAccessorFacetViaAccessor = (PropertyAccessorFacetViaAccessor)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)collectionAccessorMethod, propertyAccessorFacetViaAccessor.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(collectionAccessorMethod));
    }

    public void testPropertyAccessorFacetIsInstalledForOrderArrayAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public 1Order[] getOrders() {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PropertyAccessorFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof PropertyAccessorFacetViaAccessor));
        PropertyAccessorFacetViaAccessor propertyAccessorFacetViaAccessor = (PropertyAccessorFacetViaAccessor)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)collectionAccessorMethod, propertyAccessorFacetViaAccessor.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(collectionAccessorMethod));
    }

    public void testAddToFacetIsInstalledViaAccessorIfNoExplicitAddToMethodExists() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(CollectionAddToFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof CollectionAddToFacetViaAccessor));
        CollectionAddToFacetViaAccessor collectionAddToFacetViaAccessor = (CollectionAddToFacetViaAccessor)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)collectionAccessorMethod, collectionAddToFacetViaAccessor.getMethods().get(0));
    }

    public void testCannotInferTypeOfFacetIfNoExplicitAddToOrRemoveFromMethods() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        CollectionFieldMethodsFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(TypeOfFacet.class));
    }

    public void testRemoveFromFacetIsInstalledViaAccessorIfNoExplicitRemoveFromMethodExists() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(CollectionRemoveFromFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof CollectionRemoveFromFacetViaAccessor));
        CollectionRemoveFromFacetViaAccessor collectionRemoveFromFacetViaAccessor = (CollectionRemoveFromFacetViaAccessor)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)collectionAccessorMethod, collectionRemoveFromFacetViaAccessor.getMethods().get(0));
    }

    public void testAddToFacetIsInstalledAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }

            public void addToOrders(Order o) {
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        class Order {
            Order() {
            }
        }
        Method addToMethod = this.findMethod(Customer.class, "addToOrders", new Class[]{Order.class});
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(CollectionAddToFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof CollectionAddToFacetViaMethod));
        CollectionAddToFacetViaMethod collectionAddToFacetViaMethod = (CollectionAddToFacetViaMethod)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)addToMethod, collectionAddToFacetViaMethod.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(addToMethod));
    }

    public void testCanInferTypeOfFacetFromExplicitAddToMethod() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }

            public void addToOrders(Order o) {
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        class Order {
            Order() {
            }
        }
        Method addToMethod = this.findMethod(Customer.class, "addToOrders", new Class[]{Order.class});
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetInferredFromSupportingMethods));
        TypeOfFacetInferredFromSupportingMethods typeOfFacetInferredFromSupportingMethods = (TypeOfFacetInferredFromSupportingMethods)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetInferredFromSupportingMethods.value());
    }

    public void testRemoveFromFacetIsInstalledAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }

            public void removeFromOrders(Order o) {
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        class Order {
            Order() {
            }
        }
        Method removeFromMethod = this.findMethod(Customer.class, "removeFromOrders", new Class[]{Order.class});
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(CollectionRemoveFromFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof CollectionRemoveFromFacetViaMethod));
        CollectionRemoveFromFacetViaMethod collectionRemoveFromFacetViaMethod = (CollectionRemoveFromFacetViaMethod)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)removeFromMethod, collectionRemoveFromFacetViaMethod.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(removeFromMethod));
    }

    public void testCanInferTypeOfFacetFromExplicitRemoveFromMethod() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }

            public void removeFromOrders(Order o) {
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        class Order {
            Order() {
            }
        }
        Method removeFromMethod = this.findMethod(Customer.class, "removeFromOrders", new Class[]{Order.class});
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(TypeOfFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof TypeOfFacetInferredFromSupportingMethods));
        TypeOfFacetInferredFromSupportingMethods typeOfFacetInferredFromSupportingMethods = (TypeOfFacetInferredFromSupportingMethods)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals(Order.class, (Object)typeOfFacetInferredFromSupportingMethods.value());
    }

    public void testClearFacetIsInstalledAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }

            public void clearOrders() {
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        Method clearMethod = this.findMethod(Customer.class, "clearOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(CollectionClearFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof CollectionClearFacetViaMethod));
        CollectionClearFacetViaMethod collectionClearFacetViaMethod = (CollectionClearFacetViaMethod)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)clearMethod, collectionClearFacetViaMethod.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(clearMethod));
    }

    public void testClearFacetIsInstalledViaAccessorIfNoExplicitClearMethod() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(CollectionClearFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof CollectionClearFacetViaAccessor));
        CollectionClearFacetViaAccessor collectionClearFacetViaAccessor = (CollectionClearFacetViaAccessor)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)collectionAccessorMethod, collectionClearFacetViaAccessor.getMethods().get(0));
    }

    public void testValidateAddToFacetIsInstalledAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }

            public void addToOrders(Order o) {
            }

            public String validateAddToOrders(Order o) {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        class Order {
            Order() {
            }
        }
        Method validateAddToMethod = this.findMethod(Customer.class, "validateAddToOrders", new Class[]{Order.class});
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(CollectionValidateAddToFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof CollectionValidateAddToFacetViaMethod));
        CollectionValidateAddToFacetViaMethod collectionValidateAddToFacetViaMethod = (CollectionValidateAddToFacetViaMethod)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)validateAddToMethod, collectionValidateAddToFacetViaMethod.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(validateAddToMethod));
    }

    public void testValidateRemoveFromFacetIsInstalledAndMethodRemoved() {
        class Customer {
            Customer() {
            }

            public Collection getOrders() {
                return null;
            }

            public void removeFromOrders(Order o) {
            }

            public String validateRemoveFromOrders(Order o) {
                return null;
            }
        }
        Method collectionAccessorMethod = this.findMethod(Customer.class, "getOrders");
        class Order {
            Order() {
            }
        }
        Method validateRemoveFromMethod = this.findMethod(Customer.class, "validateRemoveFromOrders", new Class[]{Order.class});
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(CollectionValidateRemoveFromFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof CollectionValidateRemoveFromFacetViaMethod));
        CollectionValidateRemoveFromFacetViaMethod collectionValidateRemoveFromFacetViaMethod = (CollectionValidateRemoveFromFacetViaMethod)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)validateRemoveFromMethod, collectionValidateRemoveFromFacetViaMethod.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(validateRemoveFromMethod));
    }

    public void testInstallsNamedFacetUsingNameMethodAndRemovesMethod() {
        Method collectionAccessorMethod = this.findMethod(CustomerStatic.class, "getOrders");
        Method nameMethod = this.findMethod(CustomerStatic.class, "nameOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(NamedFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof NamedFacetViaMethod));
        NamedFacetViaMethod namedFacet = (NamedFacetViaMethod)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((String)"Most Recent Orders", (String)namedFacet.value());
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(nameMethod));
    }

    public void testInstallsDescribedAsFacetUsingDescriptionAndRemovesMethod() {
        Method collectionAccessorMethod = this.findMethod(CustomerStatic.class, "getOrders");
        Method descriptionMethod = this.findMethod(CustomerStatic.class, "descriptionOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DescribedAsFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DescribedAsFacetViaMethod));
        DescribedAsFacetViaMethod describedAsFacet = (DescribedAsFacetViaMethod)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((String)"Some old description", (String)describedAsFacet.value());
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(descriptionMethod));
    }

    public void testInstallsHiddenFacetUsingAlwaysHideAndRemovesMethod() {
        Method collectionAccessorMethod = this.findMethod(CustomerStatic.class, "getOrders");
        Method alwaysHideMethod = this.findMethod(CustomerStatic.class, "alwaysHideOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HiddenFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof HiddenFacetAlways));
        HiddenFacetAlways hiddenFacetAlways = (HiddenFacetAlways)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)When.ALWAYS, (Object)hiddenFacetAlways.value());
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(alwaysHideMethod));
    }

    public void testInstallsHiddenFacetUsingAlwaysHideWhenNotAndRemovesMethod() {
        Method collectionAccessorMethod = this.findMethod(CustomerStatic.class, "getOtherOrders");
        Method alwaysHideMethod = this.findMethod(CustomerStatic.class, "alwaysHideOtherOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        CollectionFieldMethodsFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(HiddenFacet.class));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(alwaysHideMethod));
    }

    public void testInstallsDisabledFacetUsingProtectAndRemovesMethod() {
        Method collectionAccessorMethod = this.findMethod(CustomerStatic.class, "getOrders");
        Method protectMethod = this.findMethod(CustomerStatic.class, "protectOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisabledFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DisabledFacetAlways));
        DisabledFacetAlways disabledFacetAlways = (DisabledFacetAlways)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)When.ALWAYS, (Object)disabledFacetAlways.value());
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(protectMethod));
    }

    public void testDoesNotInstallDisabledFacetUsingProtectWhenNotAndRemovesMethod() {
        Method collectionAccessorMethod = this.findMethod(CustomerStatic.class, "getOtherOrders");
        Method protectMethod = this.findMethod(CustomerStatic.class, "protectOtherOrders");
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        CollectionFieldMethodsFacetFactoryTest.assertNull((Object)this.facetHolder.getFacet(DisabledFacet.class));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(protectMethod));
    }

    public void testInstallsHiddenForSessionFacetAndRemovesMethod() {
        Method collectionAccessorMethod = this.findMethod(CustomerStatic.class, "getOrders");
        Method hideMethod = this.findMethod(CustomerStatic.class, "hideOrders", new Class[]{UserMemento.class});
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(HideForSessionFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof HideForSessionFacetViaMethod));
        HideForSessionFacetViaMethod hideForSessionFacetViaMethod = (HideForSessionFacetViaMethod)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)hideMethod, hideForSessionFacetViaMethod.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(hideMethod));
    }

    public void testInstallsDisabledForSessionFacetAndRemovesMethod() {
        Method collectionAccessorMethod = this.findMethod(CustomerStatic.class, "getOrders");
        Method disableMethod = this.findMethod(CustomerStatic.class, "disableOrders", new Class[]{UserMemento.class});
        this.facetFactory.process(collectionAccessorMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisableForSessionFacet.class);
        CollectionFieldMethodsFacetFactoryTest.assertNotNull((Object)facet);
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)(facet instanceof DisableForSessionFacetViaMethod));
        DisableForSessionFacetViaMethod disableForSessionFacetViaMethod = (DisableForSessionFacetViaMethod)facet;
        CollectionFieldMethodsFacetFactoryTest.assertEquals((Object)disableMethod, disableForSessionFacetViaMethod.getMethods().get(0));
        CollectionFieldMethodsFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(disableMethod));
    }

    public static class CustomerStatic {
        public Collection getOrders() {
            return null;
        }

        public static String nameOrders() {
            return "Most Recent Orders";
        }

        public static String descriptionOrders() {
            return "Some old description";
        }

        public static boolean alwaysHideOrders() {
            return true;
        }

        public static boolean protectOrders() {
            return true;
        }

        public static boolean hideOrders(UserMemento userMemento) {
            return true;
        }

        public static String disableOrders(UserMemento userMemento) {
            return "disabled for this user";
        }

        public static void getOtherOrders() {
        }

        public static boolean alwaysHideOtherOrders() {
            return false;
        }

        public static boolean protectOtherOrders() {
            return false;
        }
    }

    class Order {
        Order() {
        }
    }
}

