/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.disable;

import java.lang.reflect.Method;
import java.util.Collection;
import org.nakedobjects.applib.annotation.Disabled;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.When;
import org.nakedobjects.metamodel.facets.disable.DisabledAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.disable.DisabledFacet;
import org.nakedobjects.metamodel.facets.disable.DisabledFacetAbstract;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class DisabledAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private DisabledAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new DisabledAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        DisabledAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        DisabledAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        DisabledAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        DisabledAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        DisabledAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testDisabledAnnotationPickedUpOnProperty() {
        class Customer {
            Customer() {
            }

            @Disabled
            public int getNumberOfOrders() {
                return 0;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "getNumberOfOrders");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisabledFacet.class);
        DisabledAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        DisabledAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof DisabledFacetAbstract));
        this.assertNoMethodsRemoved();
    }

    public void testDisabledAnnotationPickedUpOnCollection() {
        class Customer {
            Customer() {
            }

            @Disabled
            public Collection getOrders() {
                return null;
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "getOrders");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisabledFacet.class);
        DisabledAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        DisabledAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof DisabledFacetAbstract));
        this.assertNoMethodsRemoved();
    }

    public void testDisabledAnnotationPickedUpOnAction() {
        class Customer {
            Customer() {
            }

            @Disabled
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisabledFacet.class);
        DisabledAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        DisabledAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof DisabledFacetAbstract));
        this.assertNoMethodsRemoved();
    }

    public void testDisabledWhenAlwaysAnnotationPickedUpOn() {
        class Customer {
            Customer() {
            }

            @Disabled(value=org.nakedobjects.applib.annotation.When.ALWAYS)
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisabledFacet.class);
        DisabledFacetAbstract disabledFacetAbstract = (DisabledFacetAbstract)facet;
        DisabledAnnotationFacetFactoryTest.assertEquals((Object)When.ALWAYS, (Object)disabledFacetAbstract.value());
    }

    public void testDisabledWhenNeverAnnotationPickedUpOn() {
        class Customer {
            Customer() {
            }

            @Disabled(value=org.nakedobjects.applib.annotation.When.NEVER)
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisabledFacet.class);
        DisabledFacetAbstract disabledFacetAbstract = (DisabledFacetAbstract)facet;
        DisabledAnnotationFacetFactoryTest.assertEquals((Object)When.NEVER, (Object)disabledFacetAbstract.value());
    }

    public void testDisabledWhenOncePersistedAnnotationPickedUpOn() {
        class Customer {
            Customer() {
            }

            @Disabled(value=org.nakedobjects.applib.annotation.When.ONCE_PERSISTED)
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisabledFacet.class);
        DisabledFacetAbstract disabledFacetAbstract = (DisabledFacetAbstract)facet;
        DisabledAnnotationFacetFactoryTest.assertEquals((Object)When.ONCE_PERSISTED, (Object)disabledFacetAbstract.value());
    }

    public void testDisabledWhenUntilPersistedAnnotationPickedUpOn() {
        class Customer {
            Customer() {
            }

            @Disabled(value=org.nakedobjects.applib.annotation.When.UNTIL_PERSISTED)
            public void someAction() {
            }
        }
        Method actionMethod = this.findMethod(Customer.class, "someAction");
        this.facetFactory.process(actionMethod, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(DisabledFacet.class);
        DisabledFacetAbstract disabledFacetAbstract = (DisabledFacetAbstract)facet;
        DisabledAnnotationFacetFactoryTest.assertEquals((Object)When.UNTIL_PERSISTED, (Object)disabledFacetAbstract.value());
    }
}

