/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.callback;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.callbacks.CreatedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.CreatedCallbackFacetFactory;
import org.nakedobjects.metamodel.facets.object.callbacks.CreatedCallbackFacetViaMethod;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class CreatedCallbackFacetFactoryTest
extends AbstractFacetFactoryTest {
    private CreatedCallbackFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new CreatedCallbackFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        CreatedCallbackFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        CreatedCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        CreatedCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        CreatedCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        CreatedCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testCreatedLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void created() {
            }
        }
        Method method = this.findMethod(Customer.class, "created");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(CreatedCallbackFacet.class);
        CreatedCallbackFacetFactoryTest.assertNotNull((Object)facet);
        CreatedCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof CreatedCallbackFacetViaMethod));
        CreatedCallbackFacetViaMethod createdCallbackFacetViaMethod = (CreatedCallbackFacetViaMethod)facet;
        CreatedCallbackFacetFactoryTest.assertEquals((Object)method, createdCallbackFacetViaMethod.getMethods().get(0));
        CreatedCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }
}

