/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.object.callback;

import java.lang.reflect.Method;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistedCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistedCallbackFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistingCallbackFacet;
import org.nakedobjects.metamodel.facets.object.callbacks.PersistingCallbackFacetViaMethod;
import org.nakedobjects.metamodel.facets.object.callbacks.SaveCallbackFacetFactory;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class SaveCallbackFacetFactoryTest
extends AbstractFacetFactoryTest {
    private SaveCallbackFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new SaveCallbackFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        SaveCallbackFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        SaveCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        SaveCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        SaveCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        SaveCallbackFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testSavingLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void saving() {
            }
        }
        Method method = this.findMethod(Customer.class, "saving");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PersistingCallbackFacet.class);
        SaveCallbackFacetFactoryTest.assertNotNull((Object)facet);
        SaveCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof PersistingCallbackFacetViaMethod));
        PersistingCallbackFacetViaMethod savingCallbackFacetViaMethod = (PersistingCallbackFacetViaMethod)facet;
        SaveCallbackFacetFactoryTest.assertEquals((Object)method, savingCallbackFacetViaMethod.getMethods().get(0));
        SaveCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }

    public void testSavedLifecycleMethodPickedUpOn() {
        class Customer {
            Customer() {
            }

            public void saved() {
            }
        }
        Method method = this.findMethod(Customer.class, "saved");
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(PersistedCallbackFacet.class);
        SaveCallbackFacetFactoryTest.assertNotNull((Object)facet);
        SaveCallbackFacetFactoryTest.assertTrue((boolean)(facet instanceof PersistedCallbackFacetViaMethod));
        PersistedCallbackFacetViaMethod savedCallbackFacetViaMethod = (PersistedCallbackFacetViaMethod)facet;
        SaveCallbackFacetFactoryTest.assertEquals((Object)method, savedCallbackFacetViaMethod.getMethods().get(0));
        SaveCallbackFacetFactoryTest.assertTrue((boolean)this.methodRemover.getRemoveMethodMethodCalls().contains(method));
    }
}

