/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.facets.ordering.fieldorder;

import org.nakedobjects.applib.annotation.FieldOrder;
import org.nakedobjects.metamodel.facets.AbstractFacetFactoryTest;
import org.nakedobjects.metamodel.facets.Facet;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.MethodRemover;
import org.nakedobjects.metamodel.facets.ordering.fieldorder.FieldOrderAnnotationFacetFactory;
import org.nakedobjects.metamodel.facets.ordering.fieldorder.FieldOrderFacet;
import org.nakedobjects.metamodel.facets.ordering.fieldorder.FieldOrderFacetAnnotation;
import org.nakedobjects.metamodel.spec.feature.NakedObjectFeatureType;

public class FieldOrderAnnotationFacetFactoryTest
extends AbstractFacetFactoryTest {
    private FieldOrderAnnotationFacetFactory facetFactory;

    protected void setUp() throws Exception {
        super.setUp();
        this.facetFactory = new FieldOrderAnnotationFacetFactory();
    }

    protected void tearDown() throws Exception {
        this.facetFactory = null;
        super.tearDown();
    }

    public void testFeatureTypes() {
        NakedObjectFeatureType[] featureTypes = this.facetFactory.getFeatureTypes();
        FieldOrderAnnotationFacetFactoryTest.assertTrue((boolean)this.contains(featureTypes, NakedObjectFeatureType.OBJECT));
        FieldOrderAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.PROPERTY));
        FieldOrderAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.COLLECTION));
        FieldOrderAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION));
        FieldOrderAnnotationFacetFactoryTest.assertFalse((boolean)this.contains(featureTypes, NakedObjectFeatureType.ACTION_PARAMETER));
    }

    public void testFieldOrderAnnotationPickedUpOnClass() {
        @FieldOrder(value="foo,bar")
        class Customer {
            Customer() {
            }
        }
        this.facetFactory.process(Customer.class, (MethodRemover)this.methodRemover, (FacetHolder)this.facetHolder);
        Facet facet = this.facetHolder.getFacet(FieldOrderFacet.class);
        FieldOrderAnnotationFacetFactoryTest.assertNotNull((Object)facet);
        FieldOrderAnnotationFacetFactoryTest.assertTrue((boolean)(facet instanceof FieldOrderFacetAnnotation));
        FieldOrderFacetAnnotation fieldOrderFacetAnnotation = (FieldOrderFacetAnnotation)facet;
        FieldOrderAnnotationFacetFactoryTest.assertEquals((String)"foo,bar", (String)fieldOrderFacetAnnotation.value());
        this.assertNoMethodsRemoved();
    }
}

