/*
 * Decompiled with CFR 0.152.
 */
package org.nakedobjects.metamodel.value;

import org.jmock.Expectations;
import org.jmock.integration.junit4.JMock;
import org.jmock.internal.ExpectationBuilder;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.nakedobjects.metamodel.adapter.TextEntryParseException;
import org.nakedobjects.metamodel.config.NakedObjectConfiguration;
import org.nakedobjects.metamodel.facets.FacetHolder;
import org.nakedobjects.metamodel.facets.FacetHolderImpl;
import org.nakedobjects.metamodel.value.IntValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.IntWrapperValueSemanticsProvider;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstract;
import org.nakedobjects.metamodel.value.ValueSemanticsProviderAbstractTestCase;

@RunWith(value=JMock.class)
public class IntValueSemanticsProviderTest
extends ValueSemanticsProviderAbstractTestCase {
    private IntValueSemanticsProviderAbstract value;
    private Integer integer;
    private FacetHolder holder;

    @Before
    public void setUpObjects() throws Exception {
        this.integer = new Integer(32);
        this.allowMockAdapterToReturn(this.integer);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((NakedObjectConfiguration)this.allowing(IntValueSemanticsProviderTest.this.mockConfiguration)).getString("nakedobjects.value.format.int");
                this.will(1.returnValue(null));
            }
        });
        this.holder = new FacetHolderImpl();
        this.value = new IntWrapperValueSemanticsProvider(this.holder, this.mockConfiguration, this.mockSpecificationLoader, this.mockRuntimeContext);
        this.setValue((ValueSemanticsProviderAbstract)this.value);
    }

    @Test
    public void testInvalidParse() throws Exception {
        try {
            this.value.parseTextEntry(null, "one");
            Assert.fail();
        }
        catch (TextEntryParseException textEntryParseException) {
            // empty catch block
        }
    }

    @Test
    public void testTitleString() {
        Assert.assertEquals((Object)"32", (Object)this.value.displayTitleOf((Object)this.integer));
    }

    @Test
    public void testParse() throws Exception {
        Object newValue = this.value.parseTextEntry(null, "120");
        Assert.assertEquals((Object)new Integer(120), (Object)newValue);
    }

    @Test
    public void testParseOddlyFormedEntry() throws Exception {
        Object newValue = this.value.parseTextEntry(null, "1,20.0");
        Assert.assertEquals((Object)new Integer(120), (Object)newValue);
    }
}

